/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory.taskmanager;

import java.util.Objects;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.FlinkMemory;
import org.apache.flink.util.Preconditions;

public class TaskExecutorFlinkMemory
implements FlinkMemory {
    private static final long serialVersionUID = 1L;
    private final MemorySize frameworkHeap;
    private final MemorySize frameworkOffHeap;
    private final MemorySize taskHeap;
    private final MemorySize taskOffHeap;
    private final MemorySize network;
    private final MemorySize managed;

    public TaskExecutorFlinkMemory(MemorySize frameworkHeap, MemorySize frameworkOffHeap, MemorySize taskHeap, MemorySize taskOffHeap, MemorySize network, MemorySize managed) {
        this.frameworkHeap = Preconditions.checkNotNull(frameworkHeap);
        this.frameworkOffHeap = Preconditions.checkNotNull(frameworkOffHeap);
        this.taskHeap = Preconditions.checkNotNull(taskHeap);
        this.taskOffHeap = Preconditions.checkNotNull(taskOffHeap);
        this.network = Preconditions.checkNotNull(network);
        this.managed = Preconditions.checkNotNull(managed);
    }

    public MemorySize getFrameworkHeap() {
        return this.frameworkHeap;
    }

    public MemorySize getFrameworkOffHeap() {
        return this.frameworkOffHeap;
    }

    public MemorySize getTaskHeap() {
        return this.taskHeap;
    }

    public MemorySize getTaskOffHeap() {
        return this.taskOffHeap;
    }

    public MemorySize getNetwork() {
        return this.network;
    }

    public MemorySize getManaged() {
        return this.managed;
    }

    @Override
    public MemorySize getJvmHeapMemorySize() {
        return this.frameworkHeap.add(this.taskHeap);
    }

    @Override
    public MemorySize getJvmDirectMemorySize() {
        return this.frameworkOffHeap.add(this.taskOffHeap).add(this.network);
    }

    @Override
    public MemorySize getTotalFlinkMemorySize() {
        return this.frameworkHeap.add(this.frameworkOffHeap).add(this.taskHeap).add(this.taskOffHeap).add(this.network).add(this.managed);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TaskExecutorFlinkMemory) {
            TaskExecutorFlinkMemory that = (TaskExecutorFlinkMemory)obj;
            return Objects.equals(this.frameworkHeap, that.frameworkHeap) && Objects.equals(this.frameworkOffHeap, that.frameworkOffHeap) && Objects.equals(this.taskHeap, that.taskHeap) && Objects.equals(this.taskOffHeap, that.taskOffHeap) && Objects.equals(this.network, that.network) && Objects.equals(this.managed, that.managed);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.frameworkHeap, this.frameworkOffHeap, this.taskHeap, this.taskOffHeap, this.network, this.managed);
    }
}

