/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateLatencyTrackOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public class LatencyTrackingStateConfig {
    private final MetricGroup metricGroup;
    private final boolean enabled;
    private final int sampleInterval;
    private final int historySize;
    private final boolean stateNameAsVariable;

    LatencyTrackingStateConfig(MetricGroup metricGroup, boolean enabled, int sampleInterval, int historySize, boolean stateNameAsVariable) {
        if (enabled) {
            Preconditions.checkNotNull(metricGroup, "Metric group cannot be null if latency tracking is enabled.");
            Preconditions.checkArgument(sampleInterval >= 1);
        }
        this.metricGroup = metricGroup;
        this.enabled = enabled;
        this.sampleInterval = sampleInterval;
        this.historySize = historySize;
        this.stateNameAsVariable = stateNameAsVariable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public boolean isStateNameAsVariable() {
        return this.stateNameAsVariable;
    }

    public static LatencyTrackingStateConfig disabled() {
        return LatencyTrackingStateConfig.newBuilder().setEnabled(false).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean enabled = StateLatencyTrackOptions.LATENCY_TRACK_ENABLED.defaultValue();
        private int sampleInterval = StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue();
        private int historySize = StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue();
        private boolean stateNameAsVariable = StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE.defaultValue();
        private MetricGroup metricGroup;

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setSampleInterval(int sampleInterval) {
            this.sampleInterval = sampleInterval;
            return this;
        }

        public Builder setHistorySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public Builder setStateNameAsVariable(boolean stateNameAsVariable) {
            this.stateNameAsVariable = stateNameAsVariable;
            return this;
        }

        public Builder setMetricGroup(MetricGroup metricGroup) {
            this.metricGroup = metricGroup;
            return this;
        }

        public Builder configure(ReadableConfig config) {
            this.setEnabled(config.get(StateLatencyTrackOptions.LATENCY_TRACK_ENABLED)).setSampleInterval(config.get(StateLatencyTrackOptions.LATENCY_TRACK_SAMPLE_INTERVAL)).setHistorySize(config.get(StateLatencyTrackOptions.LATENCY_TRACK_HISTORY_SIZE)).setStateNameAsVariable(config.get(StateLatencyTrackOptions.LATENCY_TRACK_STATE_NAME_AS_VARIABLE));
            return this;
        }

        public LatencyTrackingStateConfig build() {
            return new LatencyTrackingStateConfig(this.metricGroup, this.enabled, this.sampleInterval, this.historySize, this.stateNameAsVariable);
        }
    }
}

