/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.MutableURLClassLoader;

public final class ChildFirstClassLoader
extends FlinkUserCodeClassLoader {
    private final String[] alwaysParentFirstPatterns;

    public ChildFirstClassLoader(URL[] urls, ClassLoader parent, String[] alwaysParentFirstPatterns, Consumer<Throwable> classLoadingExceptionHandler) {
        super(urls, parent, classLoadingExceptionHandler);
        this.alwaysParentFirstPatterns = alwaysParentFirstPatterns;
    }

    @Override
    protected Class<?> loadClassWithoutExceptionHandling(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            for (String alwaysParentFirstPattern : this.alwaysParentFirstPatterns) {
                if (!name.startsWith(alwaysParentFirstPattern)) continue;
                return super.loadClassWithoutExceptionHandling(name, resolve);
            }
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                c = super.loadClassWithoutExceptionHandling(name, resolve);
            }
        } else if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL urlClassLoaderResource = this.findResource(name);
        if (urlClassLoaderResource != null) {
            return urlClassLoaderResource;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urlClassLoaderResources = this.findResources(name);
        final ArrayList<URL> result = new ArrayList<URL>();
        while (urlClassLoaderResources.hasMoreElements()) {
            result.add(urlClassLoaderResources.nextElement());
        }
        Enumeration<URL> parentResources = this.getParent().getResources(name);
        while (parentResources.hasMoreElements()) {
            result.add(parentResources.nextElement());
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = result.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public MutableURLClassLoader copy() {
        return new ChildFirstClassLoader(this.getURLs(), this.getParent(), this.alwaysParentFirstPatterns, this.classLoadingExceptionHandler);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

