/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.util;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;

public class BitSet {
    private MemorySegment memorySegment;
    private int offset;
    private int byteLength;
    private int bitLength;
    private final int BYTE_INDEX_MASK = 7;

    public BitSet(int byteSize) {
        Preconditions.checkArgument(byteSize > 0, "bits size should be greater than 0.");
        this.byteLength = byteSize;
        this.bitLength = byteSize << 3;
    }

    public void setMemorySegment(MemorySegment memorySegment, int offset) {
        Preconditions.checkArgument(memorySegment != null, "MemorySegment can not be null.");
        Preconditions.checkArgument(offset >= 0, "Offset should be positive integer.");
        Preconditions.checkArgument(offset + this.byteLength <= memorySegment.size(), "Could not set MemorySegment, the remain buffers is not enough.");
        this.memorySegment = memorySegment;
        this.offset = offset;
    }

    public void set(int index) {
        Preconditions.checkArgument(index < this.bitLength && index >= 0);
        int byteIndex = index >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        current = (byte)(current | 1 << (index & 7));
        this.memorySegment.put(this.offset + byteIndex, current);
    }

    public boolean get(int index) {
        Preconditions.checkArgument(index < this.bitLength && index >= 0);
        int byteIndex = index >>> 3;
        byte current = this.memorySegment.get(this.offset + byteIndex);
        return (current & 1 << (index & 7)) != 0;
    }

    public int bitSize() {
        return this.bitLength;
    }

    public byte[] toBytes() {
        Preconditions.checkState(!this.memorySegment.isOffHeap(), "Only support use heap memory for serialization");
        return this.memorySegment.getArray();
    }

    public void clear() {
        int index = 0;
        while (index + 8 <= this.byteLength) {
            this.memorySegment.putLong(this.offset + index, 0L);
            index += 8;
        }
        while (index < this.byteLength) {
            this.memorySegment.put(this.offset + index, (byte)0);
            ++index;
        }
    }

    public String toString() {
        StringBuilder output = new StringBuilder();
        output.append("BitSet:\n");
        output.append("\tMemorySegment:").append(this.memorySegment.size()).append("\n");
        output.append("\tOffset:").append(this.offset).append("\n");
        output.append("\tLength:").append(this.byteLength).append("\n");
        return output.toString();
    }
}

