/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;

public class ResultPartitionBytesCounter {
    private final List<Counter> subpartitionBytes = new ArrayList<Counter>();

    public ResultPartitionBytesCounter(int numSubpartitions) {
        for (int i = 0; i < numSubpartitions; ++i) {
            this.subpartitionBytes.add((Counter)new SimpleCounter());
        }
    }

    public void inc(int targetSubpartition, long bytes) {
        this.subpartitionBytes.get(targetSubpartition).inc(bytes);
    }

    public void incAll(long bytes) {
        this.subpartitionBytes.forEach(counter -> counter.inc(bytes));
    }

    public ResultPartitionBytes createSnapshot() {
        return new ResultPartitionBytes(this.subpartitionBytes.stream().mapToLong(Counter::getCount).toArray());
    }
}

