/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.maxwell;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.maxwell.MaxwellJsonDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;

public class MaxwellJsonDecodingFormat
implements ProjectableDecodingFormat<DeserializationSchema<RowData>> {
    private List<String> metadataKeys;
    private final boolean ignoreParseErrors;
    private final TimestampFormat timestampFormat;

    public MaxwellJsonDecodingFormat(boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormat = timestampFormat;
        this.metadataKeys = Collections.emptyList();
    }

    @Override
    public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType physicalDataType, int[][] projections) {
        physicalDataType = Projection.of(projections).project(physicalDataType);
        List<ReadableMetadata> readableMetadata = this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Could not find the requested metadata key: %s", k)))).collect(Collectors.toList());
        List<DataTypes.Field> metadataFields = readableMetadata.stream().map(m -> DataTypes.FIELD(m.key, m.dataType)).collect(Collectors.toList());
        DataType producedDataType = DataTypeUtils.appendRowFields(physicalDataType, metadataFields);
        TypeInformation<RowData> producedTypeInfo = context.createTypeInformation(producedDataType);
        return new MaxwellJsonDeserializationSchema(physicalDataType, readableMetadata, producedTypeInfo, this.ignoreParseErrors, this.timestampFormat);
    }

    @Override
    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        Stream.of(ReadableMetadata.values()).forEachOrdered(m -> metadataMap.put(m.key, m.dataType));
        return metadataMap;
    }

    @Override
    public void applyReadableMetadata(List<String> metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    @Override
    public ChangelogMode getChangelogMode() {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
    }

    static enum ReadableMetadata {
        DATABASE("database", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD("database", DataTypes.STRING()), new MaxwellJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }
        }),
        TABLE("table", (DataType)DataTypes.STRING().nullable(), DataTypes.FIELD("table", DataTypes.STRING()), new MaxwellJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getString(pos);
            }
        }),
        PRIMARY_KEY_COLUMNS("primary-key-columns", (DataType)DataTypes.ARRAY(DataTypes.STRING()).nullable(), DataTypes.FIELD("primary_key_columns", DataTypes.ARRAY(DataTypes.STRING())), new MaxwellJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                return row.getArray(pos);
            }
        }),
        INGESTION_TIMESTAMP("ingestion-timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(3).nullable(), DataTypes.FIELD("ts", DataTypes.BIGINT()), new MaxwellJsonDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData row, int pos) {
                if (row.isNullAt(pos)) {
                    return null;
                }
                return TimestampData.fromEpochMillis(row.getLong(pos) * 1000L);
            }
        });

        final String key;
        final DataType dataType;
        final DataTypes.Field requiredJsonField;
        final MaxwellJsonDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DataTypes.Field requiredJsonField, MaxwellJsonDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.requiredJsonField = requiredJsonField;
            this.converter = converter;
        }
    }
}

