/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.operations.Operation;

@Internal
public class AnalyzeTableOperation
implements Operation {
    private final ObjectIdentifier tableIdentifier;
    @Nullable
    private final List<CatalogPartitionSpec> partitionSpecs;
    private final List<Column> columns;

    public AnalyzeTableOperation(ObjectIdentifier tableIdentifier, @Nullable List<CatalogPartitionSpec> partitionSpecs, List<Column> columns) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSpecs = partitionSpecs;
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public Optional<List<CatalogPartitionSpec>> getPartitionSpecs() {
        return Optional.ofNullable(this.partitionSpecs);
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public String asSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ANALYZE TABLE ").append(this.tableIdentifier.toString());
        if (this.partitionSpecs != null) {
            sb.append(" PARTITION(").append(this.partitionSpecs.stream().map(p -> p.getPartitionSpec().toString()).collect(Collectors.joining(","))).append(")");
        }
        sb.append(" COMPUTE STATISTICS");
        if (!this.columns.isEmpty()) {
            sb.append(" FOR COLUMNS ").append(this.columns.stream().map(Column::getName).collect(Collectors.joining(",")));
        }
        return sb.toString();
    }
}

