/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.RestServerEndpoint;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpoint;
import org.apache.flink.table.gateway.rest.handler.application.DeployScriptHandler;
import org.apache.flink.table.gateway.rest.handler.materializedtable.RefreshMaterializedTableHandler;
import org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler.CreateEmbeddedSchedulerWorkflowHandler;
import org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler.DeleteEmbeddedSchedulerWorkflowHandler;
import org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler.ResumeEmbeddedSchedulerWorkflowHandler;
import org.apache.flink.table.gateway.rest.handler.materializedtable.scheduler.SuspendEmbeddedSchedulerWorkflowHandler;
import org.apache.flink.table.gateway.rest.handler.operation.CancelOperationHandler;
import org.apache.flink.table.gateway.rest.handler.operation.CloseOperationHandler;
import org.apache.flink.table.gateway.rest.handler.operation.GetOperationStatusHandler;
import org.apache.flink.table.gateway.rest.handler.session.CloseSessionHandler;
import org.apache.flink.table.gateway.rest.handler.session.ConfigureSessionHandler;
import org.apache.flink.table.gateway.rest.handler.session.GetSessionConfigHandler;
import org.apache.flink.table.gateway.rest.handler.session.OpenSessionHandler;
import org.apache.flink.table.gateway.rest.handler.session.TriggerSessionHeartbeatHandler;
import org.apache.flink.table.gateway.rest.handler.statement.CompleteStatementHandler;
import org.apache.flink.table.gateway.rest.handler.statement.ExecuteStatementHandler;
import org.apache.flink.table.gateway.rest.handler.statement.FetchResultsHandler;
import org.apache.flink.table.gateway.rest.handler.util.GetApiVersionHandler;
import org.apache.flink.table.gateway.rest.handler.util.GetInfoHandler;
import org.apache.flink.table.gateway.rest.header.application.DeployScriptHeaders;
import org.apache.flink.table.gateway.rest.header.materializedtable.RefreshMaterializedTableHeaders;
import org.apache.flink.table.gateway.rest.header.materializedtable.scheduler.CreateEmbeddedSchedulerWorkflowHeaders;
import org.apache.flink.table.gateway.rest.header.materializedtable.scheduler.DeleteEmbeddedSchedulerWorkflowHeaders;
import org.apache.flink.table.gateway.rest.header.materializedtable.scheduler.ResumeEmbeddedSchedulerWorkflowHeaders;
import org.apache.flink.table.gateway.rest.header.materializedtable.scheduler.SuspendEmbeddedSchedulerWorkflowHeaders;
import org.apache.flink.table.gateway.rest.header.operation.CancelOperationHeaders;
import org.apache.flink.table.gateway.rest.header.operation.CloseOperationHeaders;
import org.apache.flink.table.gateway.rest.header.operation.GetOperationStatusHeaders;
import org.apache.flink.table.gateway.rest.header.session.CloseSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.ConfigureSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.GetSessionConfigHeaders;
import org.apache.flink.table.gateway.rest.header.session.OpenSessionHeaders;
import org.apache.flink.table.gateway.rest.header.session.TriggerSessionHeartbeatHeaders;
import org.apache.flink.table.gateway.rest.header.statement.CompleteStatementHeaders;
import org.apache.flink.table.gateway.rest.header.statement.ExecuteStatementHeaders;
import org.apache.flink.table.gateway.rest.header.statement.FetchResultsHeaders;
import org.apache.flink.table.gateway.rest.header.util.GetApiVersionHeaders;
import org.apache.flink.table.gateway.rest.header.util.GetInfoHeaders;
import org.apache.flink.table.gateway.workflow.scheduler.EmbeddedQuartzScheduler;
import org.apache.flink.util.ConfigurationException;

public class SqlGatewayRestEndpoint
extends RestServerEndpoint
implements SqlGatewayEndpoint {
    public final SqlGatewayService service;
    private final EmbeddedQuartzScheduler quartzScheduler;

    public SqlGatewayRestEndpoint(Configuration configuration, SqlGatewayService sqlGatewayService) throws IOException, ConfigurationException {
        super(configuration);
        this.service = sqlGatewayService;
        this.quartzScheduler = new EmbeddedQuartzScheduler();
    }

    @VisibleForTesting
    public EmbeddedQuartzScheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    protected List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> initializeHandlers(CompletableFuture<String> localAddressFuture) {
        ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers = new ArrayList<Tuple2<RestHandlerSpecification, ChannelInboundHandler>>();
        this.addSessionRelatedHandlers(handlers);
        this.addOperationRelatedHandlers(handlers);
        this.addUtilRelatedHandlers(handlers);
        this.addStatementRelatedHandlers(handlers);
        this.addEmbeddedSchedulerRelatedHandlers(handlers);
        this.addMaterializedTableRelatedHandlers(handlers);
        this.addDeployScriptRelatedHandlers(handlers);
        return handlers;
    }

    private void addSessionRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        OpenSessionHandler openSessionHandler = new OpenSessionHandler(this.service, (Map<String, String>)this.responseHeaders, OpenSessionHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)OpenSessionHeaders.getInstance(), (Object)((Object)openSessionHandler)));
        CloseSessionHandler closeSessionHandler = new CloseSessionHandler(this.service, (Map<String, String>)this.responseHeaders, CloseSessionHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)CloseSessionHeaders.getInstance(), (Object)((Object)closeSessionHandler)));
        ConfigureSessionHandler configureSessionHandler = new ConfigureSessionHandler(this.service, (Map<String, String>)this.responseHeaders, ConfigureSessionHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)ConfigureSessionHeaders.getInstance(), (Object)((Object)configureSessionHandler)));
        GetSessionConfigHandler getSessionConfigHandler = new GetSessionConfigHandler(this.service, (Map<String, String>)this.responseHeaders, GetSessionConfigHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)GetSessionConfigHeaders.getInstance(), (Object)((Object)getSessionConfigHandler)));
        TriggerSessionHeartbeatHandler triggerSessionHeartbeatHandler = new TriggerSessionHeartbeatHandler(this.service, (Map<String, String>)this.responseHeaders, TriggerSessionHeartbeatHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)TriggerSessionHeartbeatHeaders.getInstance(), (Object)((Object)triggerSessionHeartbeatHandler)));
    }

    protected void addOperationRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        GetOperationStatusHandler getOperationStatusHandler = new GetOperationStatusHandler(this.service, (Map<String, String>)this.responseHeaders, GetOperationStatusHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)GetOperationStatusHeaders.getInstance(), (Object)((Object)getOperationStatusHandler)));
        CancelOperationHandler cancelOperationHandler = new CancelOperationHandler(this.service, (Map<String, String>)this.responseHeaders, CancelOperationHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)CancelOperationHeaders.getInstance(), (Object)((Object)cancelOperationHandler)));
        CloseOperationHandler closeOperationHandler = new CloseOperationHandler(this.service, (Map<String, String>)this.responseHeaders, CloseOperationHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)CloseOperationHeaders.getInstance(), (Object)((Object)closeOperationHandler)));
    }

    protected void addUtilRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        GetInfoHandler getInfoHandler = new GetInfoHandler(this.service, (Map<String, String>)this.responseHeaders, GetInfoHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)GetInfoHeaders.getInstance(), (Object)((Object)getInfoHandler)));
        GetApiVersionHandler getApiVersionHandler = new GetApiVersionHandler(this.service, (Map<String, String>)this.responseHeaders, GetApiVersionHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)GetApiVersionHeaders.getInstance(), (Object)((Object)getApiVersionHandler)));
    }

    private void addStatementRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        CompleteStatementHandler completeStatementHandler = new CompleteStatementHandler(this.service, (Map<String, String>)this.responseHeaders, CompleteStatementHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)CompleteStatementHeaders.getInstance(), (Object)((Object)completeStatementHandler)));
        ExecuteStatementHandler executeStatementHandler = new ExecuteStatementHandler(this.service, (Map<String, String>)this.responseHeaders, ExecuteStatementHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)ExecuteStatementHeaders.getInstance(), (Object)((Object)executeStatementHandler)));
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)FetchResultsHeaders.getDefaultInstance(), (Object)((Object)new FetchResultsHandler(this.service, (Map<String, String>)this.responseHeaders, FetchResultsHeaders.getDefaultInstance()))));
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)FetchResultsHeaders.getInstanceV1(), (Object)((Object)new FetchResultsHandler(this.service, (Map<String, String>)this.responseHeaders, FetchResultsHeaders.getInstanceV1()))));
    }

    private void addEmbeddedSchedulerRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        CreateEmbeddedSchedulerWorkflowHandler createHandler = new CreateEmbeddedSchedulerWorkflowHandler(this.service, this.quartzScheduler, this.responseHeaders, CreateEmbeddedSchedulerWorkflowHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)CreateEmbeddedSchedulerWorkflowHeaders.getInstance(), (Object)((Object)createHandler)));
        SuspendEmbeddedSchedulerWorkflowHandler suspendHandler = new SuspendEmbeddedSchedulerWorkflowHandler(this.service, this.quartzScheduler, this.responseHeaders, SuspendEmbeddedSchedulerWorkflowHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)SuspendEmbeddedSchedulerWorkflowHeaders.getInstance(), (Object)((Object)suspendHandler)));
        ResumeEmbeddedSchedulerWorkflowHandler resumeHandler = new ResumeEmbeddedSchedulerWorkflowHandler(this.service, this.quartzScheduler, this.responseHeaders, ResumeEmbeddedSchedulerWorkflowHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)ResumeEmbeddedSchedulerWorkflowHeaders.getInstance(), (Object)((Object)resumeHandler)));
        DeleteEmbeddedSchedulerWorkflowHandler deleteHandler = new DeleteEmbeddedSchedulerWorkflowHandler(this.service, this.quartzScheduler, this.responseHeaders, DeleteEmbeddedSchedulerWorkflowHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)DeleteEmbeddedSchedulerWorkflowHeaders.getInstance(), (Object)((Object)deleteHandler)));
    }

    private void addMaterializedTableRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        RefreshMaterializedTableHandler refreshMaterializedTableHandler = new RefreshMaterializedTableHandler(this.service, (Map<String, String>)this.responseHeaders, RefreshMaterializedTableHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)RefreshMaterializedTableHeaders.getInstance(), (Object)((Object)refreshMaterializedTableHandler)));
    }

    private void addDeployScriptRelatedHandlers(List<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> handlers) {
        DeployScriptHandler handler = new DeployScriptHandler(this.service, (Map<String, String>)this.responseHeaders, DeployScriptHeaders.getInstance());
        handlers.add((Tuple2<RestHandlerSpecification, ChannelInboundHandler>)Tuple2.of((Object)DeployScriptHeaders.getInstance(), (Object)((Object)handler)));
    }

    protected void startInternal() {
        this.quartzScheduler.start();
    }

    @Override
    public void stop() throws Exception {
        super.close();
        this.quartzScheduler.stop();
    }
}

