/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.handler.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.table.gateway.api.SqlGatewayService;
import org.apache.flink.table.gateway.rest.handler.AbstractSqlGatewayRestHandler;
import org.apache.flink.table.gateway.rest.message.util.GetApiVersionResponseBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;

public class GetApiVersionHandler
extends AbstractSqlGatewayRestHandler<EmptyRequestBody, GetApiVersionResponseBody, EmptyMessageParameters> {
    private final List<SqlGatewayRestAPIVersion> stableVersions;

    public GetApiVersionHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, GetApiVersionResponseBody, EmptyMessageParameters> messageHeaders) {
        this(service, responseHeaders, messageHeaders, SqlGatewayRestAPIVersion.getStableVersions());
    }

    @VisibleForTesting
    public GetApiVersionHandler(SqlGatewayService service, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, GetApiVersionResponseBody, EmptyMessageParameters> messageHeaders, List<SqlGatewayRestAPIVersion> stableVersions) {
        super(service, responseHeaders, messageHeaders);
        this.stableVersions = stableVersions;
    }

    @Override
    protected CompletableFuture<GetApiVersionResponseBody> handleRequest(@Nullable SqlGatewayRestAPIVersion version, @Nonnull HandlerRequest<EmptyRequestBody> request) {
        return CompletableFuture.completedFuture(new GetApiVersionResponseBody(this.stableVersions.stream().map(Enum::name).collect(Collectors.toList())));
    }
}

