/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlets.IncludeExcludeBasedFilter;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HeaderFilter
extends IncludeExcludeBasedFilter {
    private List<ConfiguredHeader> _configuredHeaders = new ArrayList<ConfiguredHeader>();
    private static final Logger LOG = Log.getLogger(HeaderFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String headerConfig = filterConfig.getInitParameter("headerConfig");
        if (headerConfig != null) {
            String[] configs;
            for (String config : configs = StringUtil.csvSplit(headerConfig)) {
                this._configuredHeaders.add(this.parseHeaderConfiguration(config));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString(), new Object[0]);
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (super.shouldFilter(httpRequest, httpResponse)) {
            for (ConfiguredHeader header : this._configuredHeaders) {
                if (header.isDate()) {
                    long headerValue = System.currentTimeMillis() + header.getMsOffset();
                    if (header.isAdd()) {
                        httpResponse.addDateHeader(header.getName(), headerValue);
                        continue;
                    }
                    httpResponse.setDateHeader(header.getName(), headerValue);
                    continue;
                }
                if (header.isAdd()) {
                    httpResponse.addHeader(header.getName(), header.getValue());
                    continue;
                }
                httpResponse.setHeader(header.getName(), header.getValue());
            }
        }
        chain.doFilter(request, response);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("\n");
        sb.append("configured headers:\n");
        for (ConfiguredHeader c : this._configuredHeaders) {
            sb.append(c).append("\n");
        }
        return sb.toString();
    }

    private ConfiguredHeader parseHeaderConfiguration(String config) {
        String[] configTokens = config.trim().split(" ", 2);
        String method = configTokens[0].trim();
        String header = configTokens[1];
        String[] headerTokens = header.trim().split(":", 2);
        String headerName = headerTokens[0].trim();
        String headerValue = headerTokens[1].trim();
        ConfiguredHeader configuredHeader = new ConfiguredHeader(headerName, headerValue, method.startsWith("add"), method.endsWith("Date"));
        return configuredHeader;
    }

    private static class ConfiguredHeader {
        private String _name;
        private String _value;
        private long _msOffset;
        private boolean _add;
        private boolean _date;

        public ConfiguredHeader(String name, String value, boolean add, boolean date) {
            this._name = name;
            this._value = value;
            this._add = add;
            this._date = date;
            if (this._date) {
                this._msOffset = Long.parseLong(this._value);
            }
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public boolean isAdd() {
            return this._add;
        }

        public boolean isDate() {
            return this._date;
        }

        public long getMsOffset() {
            return this._msOffset;
        }

        public String toString() {
            return (this._add ? "add" : "set") + (this._date ? "Date" : "") + " " + this._name + ": " + this._value;
        }
    }
}

