/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.AbstractConnectorClientConfigOverridePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalConnectorClientConfigOverridePolicy
extends AbstractConnectorClientConfigOverridePolicy {
    private static final Logger log = LoggerFactory.getLogger(PrincipalConnectorClientConfigOverridePolicy.class);
    private static final Set<String> ALLOWED_CONFIG = Stream.of("sasl.jaas.config", "sasl.mechanism", "security.protocol").collect(Collectors.toSet());

    @Override
    protected String policyName() {
        return "Principal";
    }

    @Override
    protected boolean isAllowed(ConfigValue configValue) {
        return ALLOWED_CONFIG.contains(configValue.name());
    }

    @Override
    public void configure(Map<String, ?> configs) {
        log.info("Setting up Principal policy for ConnectorClientConfigOverride. This will allow `sasl` client configuration to be overridden.");
    }
}

