/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client;

import io.vitess.client.cursor.CursorWithError;
import io.vitess.proto.Query;
import io.vitess.proto.Vtrpc;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Function;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.primitives.UnsignedLong;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.protobuf.ByteString;

public class Proto {
    public static final Function<byte[], ByteString> BYTE_ARRAY_TO_BYTE_STRING = new Function<byte[], ByteString>(){

        @Override
        public ByteString apply(byte[] from) {
            return ByteString.copyFrom(from);
        }
    };
    private static final int MAX_DECIMAL_UNIT = 30;

    public static void checkError(Vtrpc.RPCError error) throws SQLException {
        if (error != null) {
            int errno = Proto.getErrno(error.getMessage());
            String sqlState = Proto.getSQLState(error.getMessage());
            switch (error.getCode()) {
                case OK: {
                    break;
                }
                case INVALID_ARGUMENT: {
                    throw new SQLSyntaxErrorException(error.toString(), sqlState, errno);
                }
                case DEADLINE_EXCEEDED: {
                    throw new SQLTimeoutException(error.toString(), sqlState, errno);
                }
                case ALREADY_EXISTS: {
                    throw new SQLIntegrityConstraintViolationException(error.toString(), sqlState, errno);
                }
                case UNAVAILABLE: {
                    throw new SQLTransientException(error.toString(), sqlState, errno);
                }
                case UNAUTHENTICATED: {
                    throw new SQLInvalidAuthorizationSpecException(error.toString(), sqlState, errno);
                }
                case ABORTED: {
                    throw new SQLRecoverableException(error.toString(), sqlState, errno);
                }
                default: {
                    throw new SQLNonTransientException("Vitess RPC error: " + error.toString(), sqlState, errno);
                }
            }
        }
    }

    public static int getErrno(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return 0;
        }
        int tagPos = errorMessage.indexOf("(errno ");
        if (tagPos == -1) {
            return 0;
        }
        int start = tagPos + "(errno ".length();
        if (start >= errorMessage.length()) {
            return 0;
        }
        int end = errorMessage.indexOf(41, start);
        if (end == -1) {
            return 0;
        }
        try {
            return Integer.parseInt(errorMessage.substring(start, end));
        }
        catch (NumberFormatException exc) {
            return 0;
        }
    }

    public static String getSQLState(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return "";
        }
        int tagPos = errorMessage.indexOf("(sqlstate ");
        if (tagPos == -1) {
            return "";
        }
        int start = tagPos + "(sqlstate ".length();
        if (start >= errorMessage.length()) {
            return "";
        }
        int end = errorMessage.indexOf(41, start);
        if (end == -1) {
            return "";
        }
        return errorMessage.substring(start, end);
    }

    public static Query.BindVariable buildBindVariable(Object value) {
        if (value instanceof Query.BindVariable) {
            return (Query.BindVariable)value;
        }
        Query.BindVariable.Builder builder = Query.BindVariable.newBuilder();
        if (value instanceof Iterable) {
            Iterator itr = ((Iterable)value).iterator();
            if (!itr.hasNext()) {
                throw new IllegalArgumentException("Can't pass empty list as list bind variable.");
            }
            builder.setType(Query.Type.TUPLE);
            while (itr.hasNext()) {
                TypedValue tval = new TypedValue(itr.next());
                builder.addValues(Query.Value.newBuilder().setType(tval.type).setValue(tval.value).build());
            }
        } else {
            TypedValue tval = new TypedValue(value);
            builder.setType(tval.type);
            builder.setValue(tval.value);
        }
        return builder.build();
    }

    public static Query.BoundQuery bindQuery(String query, Map<String, ?> vars) {
        Query.BoundQuery.Builder boundQueryBuilder = Query.BoundQuery.newBuilder().setSql(query);
        if (vars != null) {
            for (Map.Entry<String, ?> entry : vars.entrySet()) {
                boundQueryBuilder.putBindVariables(entry.getKey(), Proto.buildBindVariable(entry.getValue()));
            }
        }
        return boundQueryBuilder.build();
    }

    public static List<CursorWithError> fromQueryResponsesToCursorList(List<Query.ResultWithError> resultWithErrorList) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Query.ResultWithError resultWithError : resultWithErrorList) {
            builder.add(new CursorWithError(resultWithError));
        }
        return builder.build();
    }

    protected static class TypedValue {
        Query.Type type;
        ByteString value;

        TypedValue(Object value) {
            if (value == null) {
                this.type = Query.Type.NULL_TYPE;
                this.value = ByteString.EMPTY;
            } else if (value instanceof String) {
                this.type = Query.Type.VARCHAR;
                this.value = ByteString.copyFromUtf8((String)value);
            } else if (value instanceof byte[]) {
                this.type = Query.Type.VARBINARY;
                this.value = ByteString.copyFrom((byte[])value);
            } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
                this.type = Query.Type.INT64;
                this.value = ByteString.copyFromUtf8(value.toString());
            } else if (value instanceof BigInteger) {
                this.type = Query.Type.VARCHAR;
                this.value = ByteString.copyFromUtf8(value.toString());
            } else if (value instanceof UnsignedLong) {
                this.type = Query.Type.UINT64;
                this.value = ByteString.copyFromUtf8(value.toString());
            } else if (value instanceof Float || value instanceof Double) {
                this.type = Query.Type.FLOAT64;
                this.value = ByteString.copyFromUtf8(value.toString());
            } else if (value instanceof Boolean) {
                this.type = Query.Type.INT64;
                this.value = ByteString.copyFromUtf8((Boolean)value != false ? "1" : "0");
            } else if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)value;
                if (bigDecimal.scale() > 30) {
                    bigDecimal = bigDecimal.setScale(30, 4);
                }
                this.type = Query.Type.DECIMAL;
                this.value = ByteString.copyFromUtf8(bigDecimal.toPlainString());
            } else {
                throw new IllegalArgumentException("unsupported type for Query.Value proto: " + value.getClass());
            }
        }
    }
}

