/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.NotThreadSafe;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.cache.Cache;

@NotThreadSafe
public class LRUCacheMap<K, V>
implements Cache<K, V> {
    private final LinkedHashMap<K, V> delegate;

    public LRUCacheMap(final int maxSize) {
        this.delegate = new LinkedHashMap<K, V>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxSize;
            }
        };
    }

    @Override
    public V get(K key) {
        return this.delegate.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.delegate.put(key, value);
    }

    @Override
    public boolean remove(K key) {
        return this.delegate.remove(key) != null;
    }

    @Override
    public long size() {
        return this.delegate.size();
    }

    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    public Collection<V> values() {
        return this.delegate.values();
    }

    public String toString() {
        return this.delegate.toString();
    }
}

