/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.vitess.proto.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class VitessType {
    private final String name;
    private final int jdbcId;
    private final List<String> enumValues;

    public VitessType(String name, int jdbcId) {
        this(name, jdbcId, Collections.emptyList());
    }

    public VitessType(String name, int jdbcId, List<String> enumValues) {
        this.name = name;
        this.jdbcId = jdbcId;
        this.enumValues = Collections.unmodifiableList(enumValues);
    }

    public String getName() {
        return this.name;
    }

    public int getJdbcId() {
        return this.jdbcId;
    }

    public List<String> getEnumValues() {
        return this.enumValues;
    }

    public boolean isEnum() {
        return !this.enumValues.isEmpty();
    }

    public String toString() {
        return "VitessType{name='" + this.name + '\'' + ", jdbcId=" + this.jdbcId + ", enumValues=" + this.enumValues + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VitessType that = (VitessType)o;
        return this.jdbcId == that.jdbcId && this.name.equals(that.name) && Objects.equals(this.enumValues, that.enumValues);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.jdbcId, this.enumValues);
    }

    public static VitessType resolve(Query.Field field) {
        String type;
        switch (type = field.getType().name()) {
            case "INT8": 
            case "UINT8": 
            case "INT16": {
                return new VitessType(type, 5);
            }
            case "UINT16": 
            case "INT24": 
            case "UINT24": 
            case "INT32": {
                return new VitessType(type, 4);
            }
            case "ENUM": {
                return new VitessType(type, 4, VitessType.resolveEnumAndSetValues(field.getColumnType()));
            }
            case "SET": {
                return new VitessType(type, -5, VitessType.resolveEnumAndSetValues(field.getColumnType()));
            }
            case "UINT32": 
            case "INT64": {
                return new VitessType(type, -5);
            }
            case "BLOB": {
                return new VitessType(type, 2004);
            }
            case "VARBINARY": 
            case "BINARY": {
                return new VitessType(type, -2);
            }
            case "UINT64": 
            case "VARCHAR": 
            case "CHAR": 
            case "TEXT": 
            case "JSON": 
            case "DECIMAL": 
            case "TIME": 
            case "DATE": 
            case "DATETIME": 
            case "TIMESTAMP": 
            case "YEAR": {
                return new VitessType(type, 12);
            }
            case "FLOAT32": {
                return new VitessType(type, 6);
            }
            case "FLOAT64": {
                return new VitessType(type, 8);
            }
        }
        return new VitessType(type, 1111);
    }

    private static List<String> resolveEnumAndSetValues(String definition) {
        ArrayList<String> values = new ArrayList<String>();
        if (definition == null || definition.length() == 0) {
            return values;
        }
        StringBuilder sb = new StringBuilder();
        boolean startCollecting = false;
        char[] chars = definition.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\'') {
                if (chars[i + 1] != '\'') {
                    if (startCollecting) {
                        values.add(sb.toString());
                        sb.setLength(0);
                    }
                    startCollecting = !startCollecting;
                    continue;
                }
                sb.append("'");
                ++i;
                continue;
            }
            if (!startCollecting) continue;
            sb.append(chars[i]);
        }
        return values;
    }
}

