/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VitessPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public VitessPartition(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf(SERVER_PARTITION_KEY, this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VitessPartition other = (VitessPartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    public String toString() {
        return "VitessPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    static class Provider
    implements Partition.Provider<VitessPartition> {
        private final VitessConnectorConfig connectorConfig;

        Provider(VitessConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public Set<VitessPartition> getPartitions() {
            return Collections.singleton(new VitessPartition(this.connectorConfig.getLogicalName()));
        }
    }
}

