/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer.event;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.runtime.partitioning.PartitioningEvent;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.cdc.runtime.serializer.event.EventSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public class PartitioningEventSerializer
extends TypeSerializerSingleton<PartitioningEvent> {
    public static final PartitioningEventSerializer INSTANCE = new PartitioningEventSerializer();
    private final EventSerializer eventSerializer = EventSerializer.INSTANCE;

    public boolean isImmutableType() {
        return false;
    }

    public PartitioningEvent createInstance() {
        return PartitioningEvent.ofDistributed(null, -1, -1);
    }

    public PartitioningEvent copy(PartitioningEvent from) {
        return PartitioningEvent.ofDistributed(this.eventSerializer.copy(from.getPayload()), from.getSourcePartition(), from.getTargetPartition());
    }

    public PartitioningEvent copy(PartitioningEvent from, PartitioningEvent reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(PartitioningEvent record, DataOutputView target) throws IOException {
        this.eventSerializer.serialize(record.getPayload(), target);
        target.writeInt(record.getSourcePartition());
        target.writeInt(record.getTargetPartition());
    }

    public PartitioningEvent deserialize(DataInputView source) throws IOException {
        Event payload = this.eventSerializer.deserialize(source);
        int sourcePartition = source.readInt();
        int targetPartition = source.readInt();
        return PartitioningEvent.ofDistributed(payload, sourcePartition, targetPartition);
    }

    public PartitioningEvent deserialize(PartitioningEvent reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        PartitioningEvent deserialized = this.deserialize(source);
        this.serialize(deserialized, target);
    }

    public TypeSerializerSnapshot<PartitioningEvent> snapshotConfiguration() {
        return new PartitioningEventSerializerSnapshot();
    }

    public static final class PartitioningEventSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<PartitioningEvent> {
        public PartitioningEventSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

