/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class ByteSerializer
extends TypeSerializerSingleton<Byte> {
    private static final long serialVersionUID = 1L;
    public static final ByteSerializer INSTANCE = new ByteSerializer();
    private static final Byte ZERO = 0;

    public boolean isImmutableType() {
        return true;
    }

    public Byte createInstance() {
        return ZERO;
    }

    public Byte copy(Byte from) {
        return from;
    }

    public Byte copy(Byte from, Byte reuse) {
        return from;
    }

    public int getLength() {
        return 1;
    }

    public void serialize(Byte record, DataOutputView target) throws IOException {
        target.writeByte((int)record.byteValue());
    }

    public Byte deserialize(DataInputView source) throws IOException {
        return source.readByte();
    }

    public Byte deserialize(Byte reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeByte((int)source.readByte());
    }

    public TypeSerializerSnapshot<Byte> snapshotConfiguration() {
        return new ByteSerializerSnapshot();
    }

    public static final class ByteSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Byte> {
        public ByteSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

