/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.operators.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.runtime.operators.schema.common.CoordinationResponseUtils;
import org.apache.flink.cdc.runtime.operators.schema.common.event.FlushSuccessEvent;
import org.apache.flink.cdc.runtime.operators.schema.common.event.GetEvolvedSchemaRequest;
import org.apache.flink.cdc.runtime.operators.schema.common.event.GetEvolvedSchemaResponse;
import org.apache.flink.cdc.runtime.operators.schema.common.event.GetOriginalSchemaRequest;
import org.apache.flink.cdc.runtime.operators.schema.common.event.GetOriginalSchemaResponse;
import org.apache.flink.cdc.runtime.operators.schema.common.event.SinkWriterRegisterEvent;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.SerializedValue;

public class SchemaEvolutionClient {
    private final TaskOperatorEventGateway toCoordinator;
    private final OperatorID schemaOperatorID;

    public SchemaEvolutionClient(TaskOperatorEventGateway toCoordinator, OperatorID schemaOperatorID) {
        this.toCoordinator = toCoordinator;
        this.schemaOperatorID = schemaOperatorID;
    }

    public void registerSubtask(int subtask) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new SinkWriterRegisterEvent(subtask)));
    }

    public void notifyFlushSuccess(int subtask, int sourceSubTaskId) throws IOException {
        this.toCoordinator.sendOperatorEventToCoordinator(this.schemaOperatorID, new SerializedValue((Object)new FlushSuccessEvent(subtask, sourceSubTaskId)));
    }

    public Optional<Schema> getLatestEvolvedSchema(TableId tableId) throws Exception {
        GetEvolvedSchemaResponse getEvolvedSchemaResponse = (GetEvolvedSchemaResponse)CoordinationResponseUtils.unwrap((CoordinationResponse)this.toCoordinator.sendRequestToCoordinator(this.schemaOperatorID, new SerializedValue((Object)GetEvolvedSchemaRequest.ofLatestSchema(tableId))).get());
        return getEvolvedSchemaResponse.getSchema();
    }

    public Optional<Schema> getLatestOriginalSchema(TableId tableId) throws Exception {
        GetOriginalSchemaResponse getOriginalSchemaResponse = (GetOriginalSchemaResponse)CoordinationResponseUtils.unwrap((CoordinationResponse)this.toCoordinator.sendRequestToCoordinator(this.schemaOperatorID, new SerializedValue((Object)GetOriginalSchemaRequest.ofLatestSchema(tableId))).get());
        return getOriginalSchemaResponse.getSchema();
    }
}

