/*
 * Decompiled with CFR 0.152.
 */
package io.vitess.client.cursor;

import io.vitess.client.StreamIterator;
import io.vitess.client.cursor.Cursor;
import io.vitess.client.cursor.Row;
import io.vitess.proto.Query;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class StreamCursor
extends Cursor {
    private StreamIterator<Query.QueryResult> streamIterator;
    private Iterator<Query.Row> rowIterator;
    private List<Query.Field> fields;

    public StreamCursor(StreamIterator<Query.QueryResult> streamIterator) {
        this.streamIterator = streamIterator;
    }

    @Override
    public long getRowsAffected() throws SQLException {
        throw new SQLFeatureNotSupportedException("getRowsAffected() is not supported on StreamCursor");
    }

    @Override
    public long getInsertId() throws SQLException {
        throw new SQLFeatureNotSupportedException("getInsertId() is not supported on StreamCursor");
    }

    @Override
    public List<Query.Field> getFields() throws SQLException {
        if (this.streamIterator == null) {
            throw new SQLDataException("getFields() called on closed Cursor");
        }
        if (this.fields == null && !this.nextQueryResult()) {
            throw new SQLDataException("stream ended before fields were received");
        }
        return this.fields;
    }

    @Override
    public void close() throws Exception {
        this.streamIterator.close();
        this.streamIterator = null;
    }

    @Override
    public Row next() throws SQLException {
        if (this.streamIterator == null) {
            throw new SQLDataException("next() called on closed Cursor");
        }
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            return new Row(this.getFieldMap(), this.rowIterator.next());
        }
        while (this.nextQueryResult()) {
            if (!this.rowIterator.hasNext()) continue;
            return new Row(this.getFieldMap(), this.rowIterator.next());
        }
        return null;
    }

    private boolean nextQueryResult() throws SQLException {
        if (this.streamIterator.hasNext()) {
            Query.QueryResult queryResult = this.streamIterator.next();
            if (this.fields == null) {
                this.fields = queryResult.getFieldsList();
            }
            this.rowIterator = queryResult.getRowsList().iterator();
            return true;
        }
        this.rowIterator = null;
        return false;
    }
}

