/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess.connection;

import io.debezium.connector.vitess.VitessType;
import io.debezium.connector.vitess.connection.ReplicationMessage;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessColumnValue
implements ReplicationMessage.ColumnValue<byte[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessColumnValue.class);
    private final byte[] value;

    public VitessColumnValue(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] getRawValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public byte[] asBytes() {
        return this.value;
    }

    @Override
    public String asString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public Integer asInteger() {
        return Integer.valueOf(this.asString());
    }

    @Override
    public Short asShort() {
        return Short.valueOf(this.asString());
    }

    @Override
    public Long asLong() {
        return Long.valueOf(this.asString());
    }

    @Override
    public Float asFloat() {
        return Float.valueOf(this.asString());
    }

    @Override
    public Double asDouble() {
        return Double.valueOf(this.asString());
    }

    @Override
    public Object asDefault(VitessType vitessType, boolean includeUnknownDatatypes) {
        if (includeUnknownDatatypes) {
            LOGGER.warn("process unknown column type {} as string", (Object)vitessType);
            return this.asString();
        }
        LOGGER.warn("ignore unknown column type {}", (Object)vitessType);
        return null;
    }
}

