/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.internals;

import java.io.Closeable;
import java.util.List;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerInterceptors<K, V>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProducerInterceptors.class);
    private final List<ProducerInterceptor<K, V>> interceptors;

    public ProducerInterceptors(List<ProducerInterceptor<K, V>> interceptors) {
        this.interceptors = interceptors;
    }

    public ProducerRecord<K, V> onSend(ProducerRecord<K, V> record) {
        ProducerRecord<K, V> interceptRecord = record;
        for (ProducerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptRecord = interceptor.onSend(interceptRecord);
            }
            catch (Exception e) {
                if (record != null) {
                    log.warn("Error executing interceptor onSend callback for topic: {}, partition: {}", record.topic(), record.partition(), e);
                    continue;
                }
                log.warn("Error executing interceptor onSend callback", e);
            }
        }
        return interceptRecord;
    }

    public void onAcknowledgement(RecordMetadata metadata, Exception exception) {
        for (ProducerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptor.onAcknowledgement(metadata, exception);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onAcknowledgement callback", e);
            }
        }
    }

    public void onSendError(ProducerRecord<K, V> record, TopicPartition interceptTopicPartition, Exception exception) {
        for (ProducerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                if (record == null && interceptTopicPartition == null) {
                    interceptor.onAcknowledgement(null, exception);
                    continue;
                }
                if (interceptTopicPartition == null) {
                    interceptTopicPartition = ProducerInterceptors.extractTopicPartition(record);
                }
                interceptor.onAcknowledgement(new RecordMetadata(interceptTopicPartition, -1L, -1, -1L, -1, -1), exception);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onAcknowledgement callback", e);
            }
        }
    }

    public static <K, V> TopicPartition extractTopicPartition(ProducerRecord<K, V> record) {
        return new TopicPartition(record.topic(), record.partition() == null ? -1 : record.partition());
    }

    @Override
    public void close() {
        for (ProducerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptor.close();
            }
            catch (Exception e) {
                log.error("Failed to close producer interceptor ", e);
            }
        }
    }
}

