/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.types.utils.runtime;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.memory.DataInputView;

public class DataInputViewStream
extends InputStream {
    protected DataInputView inputView;

    public DataInputViewStream(DataInputView inputView) {
        this.inputView = inputView;
    }

    public DataInputView getInputView() {
        return this.inputView;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.inputView.readUnsignedByte();
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long toSkipRemaining;
        int skippedBytes;
        for (toSkipRemaining = n; toSkipRemaining > Integer.MAX_VALUE; toSkipRemaining -= (long)skippedBytes) {
            skippedBytes = this.inputView.skipBytes(Integer.MAX_VALUE);
            if (skippedBytes != 0) continue;
            return n - toSkipRemaining;
        }
        return n - (toSkipRemaining - (long)this.inputView.skipBytes((int)toSkipRemaining));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputView.read(b, off, len);
    }
}

