/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.schema;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.utils.Predicates;

public class Selectors {
    private List<Selector> selectors;

    private Selectors() {
    }

    public boolean isMatch(TableId tableId) {
        for (Selector selector : this.selectors) {
            if (!selector.isMatch(tableId)) continue;
            return true;
        }
        return false;
    }

    public static class SelectorsBuilder {
        private List<Selector> selectors;

        public SelectorsBuilder includeTables(String tableInclusions) {
            if (tableInclusions == null || tableInclusions.isEmpty()) {
                throw new IllegalArgumentException("Invalid table inclusion pattern cannot be null or empty");
            }
            ArrayList<Selector> selectors = new ArrayList<Selector>();
            Set<String> tableSplitSet = Predicates.setOf(tableInclusions, Predicates.RegExSplitterByComma::split, str -> str);
            for (String tableSplit : tableSplitSet) {
                List<String> tableIdList = Predicates.listOf(tableSplit, Predicates.RegExSplitterByDot::split, str -> str);
                Iterator<String> iterator = tableIdList.iterator();
                if (tableIdList.size() == 1) {
                    selectors.add(new Selector(null, null, iterator.next()));
                    continue;
                }
                if (tableIdList.size() == 2) {
                    selectors.add(new Selector(null, iterator.next(), iterator.next()));
                    continue;
                }
                if (tableIdList.size() == 3) {
                    selectors.add(new Selector(iterator.next(), iterator.next(), iterator.next()));
                    continue;
                }
                throw new IllegalArgumentException("Invalid table inclusion pattern: " + tableInclusions);
            }
            this.selectors = selectors;
            return this;
        }

        public Selectors build() {
            Selectors selectors = new Selectors();
            selectors.selectors = this.selectors;
            return selectors;
        }
    }

    private static class Selector {
        private final Predicate<String> namespacePred;
        private final Predicate<String> schemaNamePred;
        private final Predicate<String> tableNamePred;

        public Selector(String namespace, String schemaName, String tableName) {
            this.namespacePred = namespace == null ? namespacePred -> false : Predicates.includes(namespace);
            this.schemaNamePred = schemaName == null ? schemaNamePred -> false : Predicates.includes(schemaName);
            this.tableNamePred = tableName == null ? tableNamePred -> false : Predicates.includes(tableName);
        }

        public boolean isMatch(TableId tableId) {
            String namespace = tableId.getNamespace();
            String schemaName = tableId.getSchemaName();
            if (namespace == null || namespace.isEmpty()) {
                if (schemaName == null || schemaName.isEmpty()) {
                    return this.tableNamePred.test(tableId.getTableName());
                }
                return this.schemaNamePred.test(tableId.getSchemaName()) && this.tableNamePred.test(tableId.getTableName());
            }
            return this.namespacePred.test(tableId.getNamespace()) && this.schemaNamePred.test(tableId.getSchemaName()) && this.tableNamePred.test(tableId.getTableName());
        }
    }
}

