/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.types.DataField;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeRoot;
import org.apache.flink.cdc.common.types.DataTypes;
import org.apache.flink.cdc.common.types.RowType;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.StringUtils;

@PublicEvolving
public class Schema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Column> columns;
    private final List<String> primaryKeys;
    private final List<String> partitionKeys;
    private final Map<String, String> options;
    @Nullable
    private final String comment;
    private volatile transient Map<String, Column> nameToColumns;
    private transient int cachedHashCode;

    private Schema(List<Column> columns, List<String> primaryKeys, Map<String, String> options, @Nullable String comment) {
        this.columns = columns;
        this.primaryKeys = primaryKeys;
        this.options = options;
        this.comment = comment;
        this.partitionKeys = new ArrayList<String>();
    }

    private Schema(List<Column> columns, List<String> primaryKeys, List<String> partitionKeys, Map<String, String> options, @Nullable String comment) {
        this.columns = columns;
        this.primaryKeys = primaryKeys;
        this.partitionKeys = partitionKeys;
        this.options = options;
        this.comment = comment;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(Column::getName).collect(Collectors.toList());
    }

    public List<DataType> getColumnDataTypes() {
        return this.columns.stream().map(Column::getType).collect(Collectors.toList());
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public List<String> partitionKeys() {
        return this.partitionKeys;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public String describeOptions() {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (this.options != null && !this.options.isEmpty()) {
            stringBuilder.append(this.options);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String comment() {
        return this.comment;
    }

    public Optional<Column> getColumn(String columnName) {
        this.initializeNameToColumns();
        return Optional.ofNullable(this.nameToColumns.get(columnName));
    }

    public DataType toRowDataType() {
        DataField[] fields = (DataField[])this.columns.stream().map(Schema::columnToField).toArray(DataField[]::new);
        return DataTypes.ROW(fields).notNull();
    }

    public Schema copy(List<Column> columns) {
        return new Schema(columns, new ArrayList<String>(this.primaryKeys), new ArrayList<String>(this.partitionKeys), new HashMap<String, String>(this.options), this.comment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)o;
        return Objects.equals(this.columns, schema.columns) && Objects.equals(this.primaryKeys, schema.primaryKeys) && Objects.equals(this.partitionKeys, schema.partitionKeys) && Objects.equals(this.options, schema.options) && Objects.equals(this.comment, schema.comment);
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = Objects.hash(this.columns, this.primaryKeys, this.partitionKeys, this.options, this.comment);
        }
        return this.cachedHashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNameToColumns() {
        if (this.nameToColumns == null) {
            Schema schema = this;
            synchronized (schema) {
                if (this.nameToColumns == null) {
                    this.nameToColumns = new HashMap<String, Column>();
                    for (Column col : this.columns) {
                        this.nameToColumns.put(col.getName(), col);
                    }
                    this.nameToColumns = Collections.unmodifiableMap(this.nameToColumns);
                }
            }
        }
    }

    private static DataField columnToField(Column column) {
        return DataTypes.FIELD(column.getName(), column.getType());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("columns={");
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append(this.columns.get(i).asSummaryString());
            if (i == this.columns.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        sb.append(", primaryKeys=").append(String.join((CharSequence)";", this.primaryKeys));
        if (!this.partitionKeys.isEmpty()) {
            sb.append(", partitionKeys=").append(String.join((CharSequence)";", this.partitionKeys));
        }
        if (!StringUtils.isNullOrWhitespaceOnly(this.comment)) {
            sb.append(", comment=").append(this.comment);
        }
        sb.append(", options=").append(this.describeOptions());
        return sb.toString();
    }

    @PublicEvolving
    public static final class Builder {
        private List<Column> columns;
        private List<String> primaryKeys = new ArrayList<String>();
        private List<String> partitionKeys = new ArrayList<String>();
        private final Map<String, String> options = new HashMap<String, String>();
        @Nullable
        private String comment;
        private final Set<String> columnNames;

        public Builder() {
            this.columns = new ArrayList<Column>();
            this.columnNames = new HashSet<String>();
        }

        public Builder partitionKey(String ... columnNames) {
            this.partitionKeys = Arrays.asList(columnNames);
            return this;
        }

        public Builder partitionKey(List<String> columnNames) {
            this.partitionKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder fromRowDataType(DataType type) {
            Preconditions.checkNotNull(type, "Data type must not be null.");
            Preconditions.checkArgument(type.is(DataTypeRoot.ROW), "Data type of ROW expected.", new Object[0]);
            List<DataType> fieldDataTypes = type.getChildren();
            List<String> fieldNames = ((RowType)type).getFieldNames();
            IntStream.range(0, fieldDataTypes.size()).forEach(i -> this.physicalColumn((String)fieldNames.get(i), (DataType)fieldDataTypes.get(i)));
            return this;
        }

        public Builder physicalColumn(String columnName, DataType type) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.physicalColumn(columnName, type));
            return this;
        }

        public Builder physicalColumn(String columnName, DataType type, String comment) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.physicalColumn(columnName, type, comment));
            return this;
        }

        public Builder physicalColumn(String columnName, DataType type, String comment, String defaultValue) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.physicalColumn(columnName, type, comment, defaultValue));
            return this;
        }

        public Builder metadataColumn(String columnName, DataType type) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.metadataColumn(columnName, type));
            return this;
        }

        public Builder metadataColumn(String columnName, DataType type, String metadataKey) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.metadataColumn(columnName, type, metadataKey, null));
            return this;
        }

        public Builder metadataColumn(String columnName, DataType type, String metadataKey, String comment) {
            this.checkColumn(columnName, type);
            this.columns.add(Column.metadataColumn(columnName, type, metadataKey, comment));
            return this;
        }

        public Builder column(Column column) {
            this.checkColumn(column.getName(), column.getType());
            this.columns.add(column);
            return this;
        }

        private void checkColumn(String columnName, DataType type) {
            Preconditions.checkNotNull(columnName, "Column name must not be null.");
            Preconditions.checkNotNull(type, "Data type must not be null.");
            if (this.columnNames.contains(columnName)) {
                throw new IllegalArgumentException(String.format("Column names must be unique, the duplicate column name: '%s'", columnName));
            }
            this.columnNames.add(columnName);
        }

        public Builder primaryKey(String ... columnNames) {
            return this.primaryKey(Arrays.asList(columnNames));
        }

        public Builder primaryKey(List<String> columnNames) {
            this.primaryKeys = new ArrayList<String>(columnNames);
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options.putAll(options);
            return this;
        }

        public Builder option(String key, String value) {
            this.options.put(key, value);
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setColumns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public Schema build() {
            return new Schema(this.columns, this.primaryKeys, this.partitionKeys, this.options, this.comment);
        }
    }
}

