/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.configuration;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.ConfigurationUtils;
import org.apache.flink.cdc.common.configuration.FallbackKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    protected final HashMap<String, Object> confData;

    public Configuration() {
        this.confData = new HashMap();
    }

    public Configuration(Configuration other) {
        this.confData = new HashMap<String, Object>(other.confData);
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        configuration.confData.putAll(map);
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                this.confData.putAll(other.confData);
            }
        }
    }

    public Configuration clone() {
        Configuration config = new Configuration();
        config.addAll(this);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ConfigOption<?> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            BiFunction applier = (key, canBePrefixMap) -> {
                if (canBePrefixMap.booleanValue() && ConfigurationUtils.containsPrefixMap(this.confData, key) || this.confData.containsKey(key)) {
                    return Optional.of(true);
                }
                return Optional.empty();
            };
            return this.applyWithOption(configOption, applier).orElse(false);
        }
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        Class<?> clazz = option.getClazz();
        try {
            if (option.isList()) {
                return rawValue.map(v -> ConfigurationUtils.convertToList(v, clazz));
            }
            return rawValue.map(v -> ConfigurationUtils.convertValue(v, clazz));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' for key '%s'.", rawValue.map(Object::toString).orElse(""), option.key()), e);
        }
    }

    public <T> Configuration set(ConfigOption<T> option, T value) {
        boolean canBePrefixMap = ConfigurationUtils.canBePrefixMap(option);
        this.setValueInternal(option.key(), value, canBePrefixMap);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return new HashSet<String>(this.confData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> toMap() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, String> ret = new HashMap<String, String>(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                ret.put(entry.getKey(), ConfigurationUtils.convertToString(entry.getValue()));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean remove(ConfigOption<T> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            BiFunction<String, Boolean, Optional<T>> applier = (key, canBePrefixMap) -> {
                if (canBePrefixMap.booleanValue() && ConfigurationUtils.removePrefixMap(this.confData, key) || this.confData.remove(key) != null) {
                    return Optional.of(true);
                }
                return Optional.empty();
            };
            return this.applyWithOption(configOption, applier).orElse(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void setValueInternal(String key, T value, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            if (canBePrefixMap) {
                ConfigurationUtils.removePrefixMap(this.confData, key);
            }
            this.confData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> getRawValue(String key, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            Object valueFromExactKey = this.confData.get(key);
            if (!canBePrefixMap || valueFromExactKey != null) {
                return Optional.ofNullable(valueFromExactKey);
            }
            Map<String, String> valueFromPrefixMap = ConfigurationUtils.convertToPropertiesPrefixed(this.confData, key);
            if (valueFromPrefixMap.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(valueFromPrefixMap);
        }
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        return this.applyWithOption(configOption, this::getRawValue);
    }

    private void loggingFallback(FallbackKey fallbackKey, ConfigOption<?> configOption) {
        if (fallbackKey.isDeprecated()) {
            LOG.warn("Config uses deprecated configuration key '{}' instead of proper key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        } else {
            LOG.info("Config uses fallback configuration key '{}' instead of key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        }
    }

    private <T> Optional<T> applyWithOption(ConfigOption<?> option, BiFunction<String, Boolean, Optional<T>> applier) {
        boolean canBePrefixMap = ConfigurationUtils.canBePrefixMap(option);
        Optional<T> valueFromExactKey = applier.apply(option.key(), canBePrefixMap);
        if (valueFromExactKey.isPresent()) {
            return valueFromExactKey;
        }
        if (option.hasFallbackKeys()) {
            for (FallbackKey fallbackKey : option.fallbackKeys()) {
                Optional<T> valueFromFallbackKey = applier.apply(fallbackKey.getKey(), canBePrefixMap);
                if (!valueFromFallbackKey.isPresent()) continue;
                this.loggingFallback(fallbackKey, option);
                return valueFromFallbackKey;
            }
        }
        return Optional.empty();
    }

    public Set<String> getKeys() {
        return this.confData.keySet();
    }

    public int hashCode() {
        int hash = 0;
        for (String s : this.confData.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configuration) {
            HashMap<String, Object> otherConf = ((Configuration)obj).confData;
            for (Map.Entry<String, Object> e : this.confData.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.confData.toString();
    }
}

