/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessDatabaseSchema;
import io.debezium.connector.vitess.VitessOffsetContext;
import io.debezium.connector.vitess.VitessPartition;
import io.debezium.connector.vitess.VitessSnapshotChangeEventSource;
import io.debezium.connector.vitess.VitessStreamingChangeEventSource;
import io.debezium.connector.vitess.connection.ReplicationConnection;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;

public class VitessChangeEventSourceFactory
implements ChangeEventSourceFactory<VitessPartition, VitessOffsetContext> {
    private final VitessConnectorConfig connectorConfig;
    private final ErrorHandler errorHandler;
    private final EventDispatcher<VitessPartition, TableId> dispatcher;
    private final Clock clock;
    private final VitessDatabaseSchema schema;
    private final ReplicationConnection replicationConnection;

    public VitessChangeEventSourceFactory(VitessConnectorConfig connectorConfig, ErrorHandler errorHandler, EventDispatcher<VitessPartition, TableId> dispatcher, Clock clock, VitessDatabaseSchema schema, ReplicationConnection replicationConnection) {
        this.connectorConfig = connectorConfig;
        this.errorHandler = errorHandler;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.replicationConnection = replicationConnection;
    }

    @Override
    public SnapshotChangeEventSource<VitessPartition, VitessOffsetContext> getSnapshotChangeEventSource(SnapshotProgressListener<VitessPartition> snapshotProgressListener) {
        return new VitessSnapshotChangeEventSource((RelationalDatabaseConnectorConfig)this.connectorConfig, null, this.dispatcher, this.schema, this.clock, null);
    }

    @Override
    public StreamingChangeEventSource<VitessPartition, VitessOffsetContext> getStreamingChangeEventSource() {
        return new VitessStreamingChangeEventSource(this.dispatcher, this.errorHandler, this.clock, this.schema, this.connectorConfig, this.replicationConnection);
    }
}

