/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.runtime.serializer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.cdc.runtime.serializer.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public final class ShortSerializer
extends TypeSerializerSingleton<Short> {
    private static final long serialVersionUID = 1L;
    public static final ShortSerializer INSTANCE = new ShortSerializer();
    private static final Short ZERO = 0;

    public boolean isImmutableType() {
        return true;
    }

    public Short createInstance() {
        return ZERO;
    }

    public Short copy(Short from) {
        return from;
    }

    public Short copy(Short from, Short reuse) {
        return from;
    }

    public int getLength() {
        return 2;
    }

    public void serialize(Short record, DataOutputView target) throws IOException {
        target.writeShort((int)record.shortValue());
    }

    public Short deserialize(DataInputView source) throws IOException {
        return source.readShort();
    }

    public Short deserialize(Short reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeShort((int)source.readShort());
    }

    public TypeSerializerSnapshot<Short> snapshotConfiguration() {
        return new ShortSerializerSnapshot();
    }

    public static final class ShortSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<Short> {
        public ShortSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

