/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess.shaded.io.grpc;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Preconditions;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.BinaryLog;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.BindableService;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.CompressorRegistry;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.DecompressorRegistry;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ExperimentalApi;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.HandlerRegistry;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.Server;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ServerInterceptor;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ServerProvider;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ServerServiceDefinition;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ServerStreamTracer;
import org.apache.flink.cdc.connectors.vitess.shaded.io.grpc.ServerTransportFilter;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    public static ServerBuilder<?> forPort(int port) {
        return ServerProvider.provider().builderForPort(port);
    }

    public abstract T directExecutor();

    public abstract T executor(@Nullable Executor var1);

    public abstract T addService(ServerServiceDefinition var1);

    public abstract T addService(BindableService var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3117")
    public T intercept(ServerInterceptor interceptor) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2132")
    public T addTransportFilter(ServerTransportFilter filter) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public T addStreamTracerFactory(ServerStreamTracer.Factory factory) {
        throw new UnsupportedOperationException();
    }

    public abstract T fallbackHandlerRegistry(@Nullable HandlerRegistry var1);

    public abstract T useTransportSecurity(File var1, File var2);

    public T useTransportSecurity(InputStream certChain, InputStream privateKey) {
        throw new UnsupportedOperationException();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T decompressorRegistry(@Nullable DecompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
    public abstract T compressorRegistry(@Nullable CompressorRegistry var1);

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/3706")
    public T handshakeTimeout(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    public T maxInboundMessageSize(int bytes) {
        Preconditions.checkArgument(bytes >= 0, "bytes must be >= 0");
        return this.thisT();
    }

    public T maxInboundMetadataSize(int bytes) {
        Preconditions.checkArgument(bytes > 0, "maxInboundMetadataSize must be > 0");
        return this.thisT();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4017")
    public T setBinaryLog(BinaryLog binaryLog) {
        throw new UnsupportedOperationException();
    }

    public abstract Server build();

    private T thisT() {
        ServerBuilder thisT = this;
        return (T)thisT;
    }
}

