/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.RecordData;
import org.apache.flink.cdc.common.data.StringData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeChecks;

@PublicEvolving
public interface ArrayData {
    public int size();

    public boolean isNullAt(int var1);

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public StringData getString(int var1);

    public DecimalData getDecimal(int var1, int var2, int var3);

    public TimestampData getTimestamp(int var1, int var2);

    public LocalZonedTimestampData getLocalZonedTimestamp(int var1, int var2);

    public ZonedTimestampData getZonedTimestamp(int var1, int var2);

    public byte[] getBinary(int var1);

    public ArrayData getArray(int var1);

    public MapData getMap(int var1);

    public RecordData getRecord(int var1, int var2);

    public boolean[] toBooleanArray();

    public byte[] toByteArray();

    public short[] toShortArray();

    public int[] toIntArray();

    public long[] toLongArray();

    public float[] toFloatArray();

    public double[] toDoubleArray();

    public static ElementGetter createElementGetter(DataType elementType) {
        ElementGetter elementGetter;
        switch (elementType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                elementGetter = ArrayData::getString;
                break;
            }
            case BOOLEAN: {
                elementGetter = ArrayData::getBoolean;
                break;
            }
            case BINARY: 
            case VARBINARY: {
                elementGetter = ArrayData::getBinary;
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(elementType);
                int decimalScale = DataTypeChecks.getScale(elementType);
                elementGetter = (array, pos) -> array.getDecimal(pos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                elementGetter = ArrayData::getByte;
                break;
            }
            case SMALLINT: {
                elementGetter = ArrayData::getShort;
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                elementGetter = ArrayData::getInt;
                break;
            }
            case BIGINT: {
                elementGetter = ArrayData::getLong;
                break;
            }
            case FLOAT: {
                elementGetter = ArrayData::getFloat;
                break;
            }
            case DOUBLE: {
                elementGetter = ArrayData::getDouble;
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(elementType);
                elementGetter = (array, pos) -> array.getTimestamp(pos, timestampPrecision);
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampLtzPrecision = DataTypeChecks.getPrecision(elementType);
                elementGetter = (array, pos) -> array.getLocalZonedTimestamp(pos, timestampLtzPrecision);
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                int timestampTzPrecision = DataTypeChecks.getPrecision(elementType);
                elementGetter = (array, pos) -> array.getZonedTimestamp(pos, timestampTzPrecision);
                break;
            }
            case ARRAY: {
                elementGetter = ArrayData::getArray;
                break;
            }
            case MAP: {
                elementGetter = ArrayData::getMap;
                break;
            }
            case ROW: {
                int rowFieldCount = DataTypeChecks.getFieldCount(elementType);
                elementGetter = (array, pos) -> array.getRecord(pos, rowFieldCount);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!elementType.isNullable()) {
            return elementGetter;
        }
        return (array, pos) -> {
            if (array.isNullAt(pos)) {
                return null;
            }
            return elementGetter.getElementOrNull(array, pos);
        };
    }

    @PublicEvolving
    public static interface ElementGetter
    extends Serializable {
        @Nullable
        public Object getElementOrNull(ArrayData var1, int var2);
    }
}

