/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import io.debezium.util.Collect;
import java.util.Set;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;

public abstract class RecordParser {
    private final Struct record;
    private final Struct source;
    private final Struct transaction;
    private final String op;
    private final Schema opSchema;
    private final String ts_ms;
    private final Schema ts_msSchema;
    private final Schema dataSchema;
    private final String connectorType;
    protected static final Set<String> SOURCE_FIELDS = Collect.unmodifiableSet("version", "connector", "name", "ts_ms", "snapshot", "db");

    protected RecordParser(Schema schema, Struct record, String ... dataFields) {
        this.record = record;
        this.source = record.getStruct("source");
        this.transaction = record.schema().field("transaction") != null ? record.getStruct("transaction") : null;
        this.op = record.getString("op");
        this.opSchema = schema.field("op").schema();
        this.ts_ms = record.getInt64("ts_ms").toString();
        this.ts_msSchema = schema.field("ts_ms").schema();
        this.connectorType = this.source.getString("connector");
        this.dataSchema = RecordParser.getDataSchema(schema, this.connectorType, dataFields);
    }

    private static Schema getDataSchema(Schema schema, String connectorType, String ... fields) {
        SchemaBuilder builder = SchemaBuilder.struct().name("io.debezium.connector.mysql.Data");
        for (String field : fields) {
            builder.field(field, schema.field(field).schema());
        }
        return builder.build();
    }

    public Struct data() {
        Struct data = new Struct(this.dataSchema());
        for (Field field : this.dataSchema.fields()) {
            data.put(field, this.record.get(field));
        }
        return data;
    }

    public Struct source() {
        return this.source;
    }

    public Struct transaction() {
        return this.transaction;
    }

    public String op() {
        return this.op;
    }

    public Schema opSchema() {
        return this.opSchema;
    }

    public String ts_ms() {
        return this.ts_ms;
    }

    public Schema ts_msSchema() {
        return this.ts_msSchema;
    }

    public Schema dataSchema() {
        return this.dataSchema;
    }

    public String connectorType() {
        return this.connectorType;
    }

    public abstract Object getMetadata(String var1);
}

