/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.base.Preconditions;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableMapEntrySet;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableMapKeySet;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableMapValues;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.Maps;
import org.apache.flink.cdc.connectors.vitess.shaded.com.google.common.collect.RegularImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, Map.Entry<K, V>[] entryArray) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            entryArray[i] = RegularImmutableMap.makeImmutable(entryArray[i]);
            V oldValue = delegateMap.putIfAbsent(entryArray[i].getKey(), entryArray[i].getValue());
            if (oldValue == null) continue;
            String string = String.valueOf(entryArray[i].getKey());
            String string2 = String.valueOf(oldValue);
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i], new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries) {
        this.delegateMap = delegateMap;
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public V get(@Nullable Object key) {
        return this.delegateMap.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

