/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerScopeUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationResult;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerValidationUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerUnsecuredValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerUnsecuredValidatorCallbackHandler.class);
    private static final String OPTION_PREFIX = "unsecuredValidator";
    private static final String PRINCIPAL_CLAIM_NAME_OPTION = "unsecuredValidatorPrincipalClaimName";
    private static final String SCOPE_CLAIM_NAME_OPTION = "unsecuredValidatorScopeClaimName";
    private static final String REQUIRED_SCOPE_OPTION = "unsecuredValidatorRequiredScope";
    private static final String ALLOWABLE_CLOCK_SKEW_MILLIS_OPTION = "unsecuredValidatorAllowableClockSkewMs";
    private Time time = Time.SYSTEM;
    private Map<String, String> moduleOptions = null;
    private boolean configured = false;

    void time(Time time) {
        this.time = Objects.requireNonNull(time);
    }

    public boolean configured() {
        return this.configured;
    }

    @Override
    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException(String.format("Unexpected SASL mechanism: %s", saslMechanism));
        }
        if (Objects.requireNonNull(jaasConfigEntries).size() != 1 || jaasConfigEntries.get(0) == null) {
            throw new IllegalArgumentException(String.format("Must supply exactly 1 non-null JAAS mechanism configuration (size was %d)", jaasConfigEntries.size()));
        }
        Map<String, ?> unmodifiableModuleOptions = Collections.unmodifiableMap(jaasConfigEntries.get(0).getOptions());
        this.moduleOptions = unmodifiableModuleOptions;
        this.configured = true;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (!this.configured()) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                try {
                    this.handleCallback(validationCallback);
                }
                catch (OAuthBearerIllegalTokenException e) {
                    OAuthBearerValidationResult failureReason = e.reason();
                    String failureScope = failureReason.failureScope();
                    validationCallback.error(failureScope != null ? "insufficient_scope" : "invalid_token", failureScope, failureReason.failureOpenIdConfig());
                }
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                OAuthBearerExtensionsValidatorCallback extensionsCallback = (OAuthBearerExtensionsValidatorCallback)callback;
                extensionsCallback.inputExtensions().map().forEach((extensionName, v) -> extensionsCallback.valid((String)extensionName));
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    @Override
    public void close() {
    }

    private void handleCallback(OAuthBearerValidatorCallback callback) {
        String tokenValue = callback.tokenValue();
        if (tokenValue == null) {
            throw new IllegalArgumentException("Callback missing required token value");
        }
        String principalClaimName = this.principalClaimName();
        String scopeClaimName = this.scopeClaimName();
        List<String> requiredScope = this.requiredScope();
        int allowableClockSkewMs = this.allowableClockSkewMs();
        OAuthBearerUnsecuredJws unsecuredJwt = new OAuthBearerUnsecuredJws(tokenValue, principalClaimName, scopeClaimName);
        long now = this.time.milliseconds();
        OAuthBearerValidationUtils.validateClaimForExistenceAndType(unsecuredJwt, true, principalClaimName, String.class).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateIssuedAt(unsecuredJwt, false, now, allowableClockSkewMs).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateExpirationTime(unsecuredJwt, now, allowableClockSkewMs).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateTimeConsistency(unsecuredJwt).throwExceptionIfFailed();
        OAuthBearerValidationUtils.validateScope(unsecuredJwt, requiredScope).throwExceptionIfFailed();
        log.info("Successfully validated token with principal {}: {}", (Object)unsecuredJwt.principalName(), (Object)unsecuredJwt.claims());
        callback.token(unsecuredJwt);
    }

    private String principalClaimName() {
        String principalClaimNameValue = this.option(PRINCIPAL_CLAIM_NAME_OPTION);
        return Utils.isBlank(principalClaimNameValue) ? "sub" : principalClaimNameValue.trim();
    }

    private String scopeClaimName() {
        String scopeClaimNameValue = this.option(SCOPE_CLAIM_NAME_OPTION);
        return Utils.isBlank(scopeClaimNameValue) ? "scope" : scopeClaimNameValue.trim();
    }

    private List<String> requiredScope() {
        String requiredSpaceDelimitedScope = this.option(REQUIRED_SCOPE_OPTION);
        return Utils.isBlank(requiredSpaceDelimitedScope) ? Collections.emptyList() : OAuthBearerScopeUtils.parseScope(requiredSpaceDelimitedScope.trim());
    }

    private int allowableClockSkewMs() {
        String allowableClockSkewMsValue = this.option(ALLOWABLE_CLOCK_SKEW_MILLIS_OPTION);
        int allowableClockSkewMs = 0;
        try {
            allowableClockSkewMs = Utils.isBlank(allowableClockSkewMsValue) ? 0 : Integer.parseInt(allowableClockSkewMsValue.trim());
        }
        catch (NumberFormatException e) {
            throw new OAuthBearerConfigException(e.getMessage(), e);
        }
        if (allowableClockSkewMs < 0) {
            throw new OAuthBearerConfigException(String.format("Allowable clock skew millis must not be negative: %s", allowableClockSkewMsValue));
        }
        return allowableClockSkewMs;
    }

    private String option(String key) {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        return this.moduleOptions.get(Objects.requireNonNull(key));
    }
}

