/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.vitess;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.vitess.Filters;
import io.debezium.connector.vitess.Module;
import io.debezium.connector.vitess.VitessChangeEventSourceFactory;
import io.debezium.connector.vitess.VitessConnector;
import io.debezium.connector.vitess.VitessConnectorConfig;
import io.debezium.connector.vitess.VitessDatabaseSchema;
import io.debezium.connector.vitess.VitessErrorHandler;
import io.debezium.connector.vitess.VitessEventMetadataProvider;
import io.debezium.connector.vitess.VitessOffsetContext;
import io.debezium.connector.vitess.VitessPartition;
import io.debezium.connector.vitess.VitessTaskContext;
import io.debezium.connector.vitess.VitessTopicSelector;
import io.debezium.connector.vitess.connection.ReplicationConnection;
import io.debezium.connector.vitess.connection.VitessReplicationConnection;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.SchemaNameAdjuster;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VitessConnectorTask
extends BaseSourceTask<VitessPartition, VitessOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VitessConnectorTask.class);
    private static final String CONTEXT_NAME = "vitess-connector-task";
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile ErrorHandler errorHandler;
    private volatile VitessDatabaseSchema schema;
    private volatile ReplicationConnection replicationConnection;

    @Override
    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ChangeEventSourceCoordinator<VitessPartition, VitessOffsetContext> start(Configuration config) {
        VitessConnectorConfig connectorConfig = new VitessConnectorConfig(config);
        TopicSelector<TableId> topicSelector = VitessTopicSelector.defaultSelector(connectorConfig);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjustmentMode().createAdjuster();
        this.schema = new VitessDatabaseSchema(connectorConfig, schemaNameAdjuster, topicSelector);
        VitessTaskContext taskContext = new VitessTaskContext(connectorConfig, this.schema);
        Offsets<VitessPartition, VitessOffsetContext> previousOffsets = this.getPreviousOffsets(new VitessPartition.Provider(connectorConfig), new VitessOffsetContext.Loader(connectorConfig));
        VitessOffsetContext previousOffset = previousOffsets.getTheOnlyOffset();
        Clock clock = Clock.system();
        LoggingContext.PreviousContext previousContext = taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
            } else {
                LOGGER.info("Found previous offset {}", (Object)previousOffset);
            }
            this.replicationConnection = new VitessReplicationConnection(connectorConfig, this.schema);
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new VitessErrorHandler(connectorConfig, this.queue);
            VitessEventMetadataProvider metadataProvider = new VitessEventMetadataProvider();
            EventDispatcher<VitessPartition, TableId> dispatcher = new EventDispatcher<VitessPartition, TableId>(connectorConfig, topicSelector, this.schema, this.queue, new Filters(connectorConfig).tableFilter(), DataChangeEvent::new, metadataProvider, schemaNameAdjuster);
            ChangeEventSourceCoordinator<VitessPartition, VitessOffsetContext> coordinator = new ChangeEventSourceCoordinator<VitessPartition, VitessOffsetContext>(previousOffsets, this.errorHandler, VitessConnector.class, connectorConfig, new VitessChangeEventSourceFactory(connectorConfig, this.errorHandler, dispatcher, clock, this.schema, this.replicationConnection), new DefaultChangeEventSourceMetricsFactory(), dispatcher, this.schema);
            coordinator.start(taskContext, this.queue, metadataProvider);
            ChangeEventSourceCoordinator<VitessPartition, VitessOffsetContext> changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousContext.restore();
        }
    }

    @Override
    protected List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    @Override
    protected void doStop() {
        if (this.schema != null) {
            this.schema.close();
        }
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return VitessConnectorConfig.ALL_FIELDS;
    }
}

