/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.policy;

import java.util.concurrent.Callable;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.log.SlowLogSpan;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.HistogramUtils;
import org.tikv.shade.com.google.common.collect.ImmutableSet;
import org.tikv.shade.io.grpc.Status;
import org.tikv.shade.io.prometheus.client.Counter;
import org.tikv.shade.io.prometheus.client.Histogram;

public abstract class RetryPolicy<RespT> {
    BackOffer backOffer = ConcreteBackOffer.newCopNextMaxBackOff();
    public static final Histogram GRPC_SINGLE_REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_grpc_single_requests_latency")).help("grpc request latency.")).labelNames("type")).register();
    public static final Histogram CALL_WITH_RETRY_DURATION = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_call_with_retry_duration")).help("callWithRetry duration.")).labelNames("type")).register();
    public static final Counter GRPC_REQUEST_RETRY_NUM = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("client_java_grpc_requests_retry_num")).help("grpc request retry num.")).labelNames("type")).register();
    private final ErrorHandler<RespT> handler;
    private final ImmutableSet<Status.Code> unrecoverableStatus = ImmutableSet.of(Status.Code.ALREADY_EXISTS, Status.Code.PERMISSION_DENIED, Status.Code.INVALID_ARGUMENT, Status.Code.NOT_FOUND, Status.Code.UNIMPLEMENTED, Status.Code.OUT_OF_RANGE, new Status.Code[]{Status.Code.UNAUTHENTICATED, Status.Code.CANCELLED});

    RetryPolicy(ErrorHandler<RespT> handler) {
        this.handler = handler;
    }

    private void rethrowNotRecoverableException(Exception e) {
        Status status = Status.fromThrowable(e);
        if (this.unrecoverableStatus.contains((Object)status.getCode())) {
            throw new GrpcException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespT callWithRetry(Callable<RespT> proc, String methodName, BackOffer backOffer) {
        Histogram.Timer callWithRetryTimer = ((Histogram.Child)CALL_WITH_RETRY_DURATION.labels(methodName)).startTimer();
        SlowLogSpan callWithRetrySlowLogSpan = backOffer.getSlowLog().start("callWithRetry");
        callWithRetrySlowLogSpan.addProperty("method", methodName);
        try {
            RespT result;
            while (true) {
                boolean retry;
                result = null;
                try {
                    Histogram.Timer requestTimer = ((Histogram.Child)GRPC_SINGLE_REQUEST_LATENCY.labels(methodName)).startTimer();
                    SlowLogSpan slowLogSpan = backOffer.getSlowLog().start("gRPC");
                    slowLogSpan.addProperty("method", methodName);
                    try {
                        result = proc.call();
                    }
                    finally {
                        slowLogSpan.end();
                        requestTimer.observeDuration();
                    }
                }
                catch (Exception e) {
                    this.rethrowNotRecoverableException(e);
                    backOffer.checkTimeout();
                    boolean retry2 = this.handler.handleRequestError(backOffer, e);
                    if (retry2) {
                        ((Counter.Child)GRPC_REQUEST_RETRY_NUM.labels(methodName)).inc();
                        continue;
                    }
                    RespT RespT = result;
                    callWithRetryTimer.observeDuration();
                    callWithRetrySlowLogSpan.end();
                    return RespT;
                }
                if (this.handler == null || !(retry = this.handler.handleResponseError(backOffer, result))) break;
                ((Counter.Child)GRPC_REQUEST_RETRY_NUM.labels(methodName)).inc();
            }
            RespT RespT = result;
            return RespT;
        }
        finally {
            callWithRetryTimer.observeDuration();
            callWithRetrySlowLogSpan.end();
        }
    }

    public static interface Builder<T> {
        public RetryPolicy<T> create(ErrorHandler<T> var1);
    }
}

