/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.table;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverter;
import org.apache.flink.cdc.debezium.table.DeserializationRuntimeConverterFactory;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;

public class SqlServerDeserializationConverterFactory {
    public static DeserializationRuntimeConverterFactory instance() {
        return new DeserializationRuntimeConverterFactory(){
            private static final long serialVersionUID = 1L;

            @Override
            public Optional<DeserializationRuntimeConverter> createUserDefinedConverter(LogicalType logicalType, ZoneId serverTimeZone) {
                switch (logicalType.getTypeRoot()) {
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        return SqlServerDeserializationConverterFactory.convertToLocalTimeZoneTimestamp();
                    }
                }
                return Optional.empty();
            }
        };
    }

    private static Optional<DeserializationRuntimeConverter> convertToLocalTimeZoneTimestamp() {
        return Optional.of(new DeserializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(Object dbzObj, Schema schema) {
                if (dbzObj instanceof String) {
                    String str = (String)dbzObj;
                    Instant parse = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)str, Instant::from);
                    return TimestampData.fromInstant((Instant)parse);
                }
                throw new IllegalArgumentException("Unable to convert to TimestampData from unexpected value '" + dbzObj + "' of type " + dbzObj.getClass().getName());
            }
        });
    }
}

