/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.debezium.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.event.DataChangeEvent;
import org.apache.flink.cdc.common.event.Event;
import org.apache.flink.cdc.common.event.EventDeserializer;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class SourceRecordEventDeserializer
implements EventDeserializer<SourceRecord> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(SourceRecordEventDeserializer.class);

    public List<? extends Event> deserialize(SourceRecord record) throws Exception {
        if (this.isDataChangeRecord(record)) {
            LOG.trace("Process data change record: {}", (Object)record);
            return this.deserializeDataChangeRecord(record);
        }
        if (this.isSchemaChangeRecord(record)) {
            LOG.trace("Process schema change record: {}", (Object)record);
            return this.deserializeSchemaChangeRecord(record);
        }
        LOG.trace("Ignored other record: {}", (Object)record);
        return Collections.emptyList();
    }

    protected abstract boolean isDataChangeRecord(SourceRecord var1);

    protected abstract boolean isSchemaChangeRecord(SourceRecord var1);

    protected abstract List<DataChangeEvent> deserializeDataChangeRecord(SourceRecord var1) throws Exception;

    protected abstract List<SchemaChangeEvent> deserializeSchemaChangeRecord(SourceRecord var1) throws Exception;

    protected abstract TableId getTableId(SourceRecord var1);

    protected abstract Map<String, String> getMetadata(SourceRecord var1);

    public static Schema fieldSchema(Schema schema, String fieldName) {
        return schema.field(fieldName).schema();
    }

    public static Struct fieldStruct(Struct value, String fieldName) {
        return value.getStruct(fieldName);
    }
}

