/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.sqlserver.source.utils;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class SqlServerTypeUtils {
    static final String UNIQUEIDENTIFIRER = "uniqueidentifier";

    public static DataType fromDbzColumn(Column column) {
        DataType dataType = SqlServerTypeUtils.convertFromColumn(column);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column) {
        switch (column.jdbcType()) {
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 2002: 
            case 2005: {
                return DataTypes.STRING();
            }
            case 2004: {
                return DataTypes.BYTES();
            }
            case -6: 
            case 4: 
            case 5: {
                return DataTypes.INT();
            }
            case -5: {
                return DataTypes.BIGINT();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return DataTypes.DECIMAL((int)column.length(), (int)column.scale().orElse(0));
            }
            case 91: {
                return DataTypes.DATE();
            }
            case 93: 
            case 2014: {
                return column.scale().isPresent() ? DataTypes.TIMESTAMP((int)column.scale().get()) : DataTypes.TIMESTAMP();
            }
            case 16: {
                return DataTypes.BOOLEAN();
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support SqlSever type '%s' yet, jdbcType:'%s'.", column.typeName(), column.jdbcType()));
    }
}

