/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;

public class DataOutputStreamWritable
implements Writable,
Closeable {
    protected final DataOutputStream out;

    public DataOutputStreamWritable(DataOutputStream out) {
        this.out = out;
    }

    @Override
    public void writeByte(byte val) {
        try {
            this.out.writeByte(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeShort(short val) {
        try {
            this.out.writeShort(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeInt(int val) {
        try {
            this.out.writeInt(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeLong(long val) {
        try {
            this.out.writeLong(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeDouble(double val) {
        try {
            this.out.writeDouble(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeByteArray(byte[] arr) {
        try {
            this.out.write(arr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeUnsignedVarint(int i) {
        try {
            ByteUtils.writeUnsignedVarint(i, this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeByteBuffer(ByteBuffer buf) {
        try {
            if (buf.hasArray()) {
                this.out.write(buf.array(), buf.position(), buf.limit());
            } else {
                byte[] bytes = Utils.toArray(buf);
                this.out.write(bytes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeVarint(int i) {
        try {
            ByteUtils.writeVarint(i, this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeVarlong(long i) {
        try {
            ByteUtils.writeVarlong(i, this.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

