/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.relational.connection;

import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.connectors.base.config.JdbcSourceConfig;
import org.apache.flink.cdc.connectors.base.relational.connection.ConnectionPoolId;
import org.apache.flink.cdc.connectors.base.relational.connection.ConnectionPools;
import org.apache.flink.cdc.connectors.base.relational.connection.JdbcConnectionPoolFactory;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnectionPools
implements ConnectionPools<HikariDataSource, JdbcSourceConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcConnectionPools.class);
    private static JdbcConnectionPools instance;
    private final Map<ConnectionPoolId, HikariDataSource> pools = new HashMap<ConnectionPoolId, HikariDataSource>();
    private static final Map<String, JdbcConnectionPoolFactory> POOL_FACTORY_MAP;

    private JdbcConnectionPools() {
    }

    public static synchronized JdbcConnectionPools getInstance(JdbcConnectionPoolFactory jdbcConnectionPoolFactory) {
        if (instance == null) {
            instance = new JdbcConnectionPools();
        }
        POOL_FACTORY_MAP.put(jdbcConnectionPoolFactory.getClass().getName(), jdbcConnectionPoolFactory);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikariDataSource getOrCreateConnectionPool(ConnectionPoolId poolId, JdbcSourceConfig sourceConfig) {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            if (!this.pools.containsKey(poolId)) {
                LOG.info("Create and register connection pool {}", (Object)poolId);
                JdbcConnectionPoolFactory jdbcConnectionPoolFactory = POOL_FACTORY_MAP.get(poolId.getDataSourcePoolFactoryIdentifier());
                if (jdbcConnectionPoolFactory == null) {
                    throw new FlinkRuntimeException(String.format("Pool factory identifier is required for connection pool, but unknown pool factory identifier %s found.", poolId.getDataSourcePoolFactoryIdentifier()));
                }
                this.pools.put(poolId, jdbcConnectionPoolFactory.createPooledDataSource(sourceConfig));
            }
            return this.pools.get(poolId);
        }
    }

    @VisibleForTesting
    public String getJdbcUrl(JdbcSourceConfig sourceConfig, String dataSourcePoolFactoryIdentifier) {
        JdbcConnectionPoolFactory jdbcConnectionPoolFactory = POOL_FACTORY_MAP.get(dataSourcePoolFactoryIdentifier);
        if (jdbcConnectionPoolFactory == null) {
            throw new FlinkRuntimeException(String.format("Pool factory identifier is required for connection pools, but unknown pool factory identifier %s found.", dataSourcePoolFactoryIdentifier));
        }
        return jdbcConnectionPoolFactory.getJdbcUrl(sourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        Map<ConnectionPoolId, HikariDataSource> map = this.pools;
        synchronized (map) {
            this.pools.values().stream().forEach(HikariDataSource::close);
            this.pools.clear();
            POOL_FACTORY_MAP.clear();
        }
    }

    static {
        POOL_FACTORY_MAP = new HashMap<String, JdbcConnectionPoolFactory>();
    }
}

