/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.data.Envelope;
import java.util.Map;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmtManager<R extends ConnectRecord<R>> {
    private static final String RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX = ".Key";
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtManager.class);

    public SmtManager(Configuration config) {
    }

    public boolean isValidEnvelope(R record) {
        if (((ConnectRecord)record).valueSchema() == null || ((ConnectRecord)record).valueSchema().name() == null || !Envelope.isEnvelopeSchema(((ConnectRecord)record).valueSchema())) {
            LOGGER.debug("Expected Envelope for transformation, passing it unchanged");
            return false;
        }
        return true;
    }

    public boolean isValidKey(R record) {
        if (((ConnectRecord)record).keySchema() == null || ((ConnectRecord)record).keySchema().name() == null || !((ConnectRecord)record).keySchema().name().endsWith(RECORD_ENVELOPE_KEY_SCHEMA_NAME_SUFFIX)) {
            LOGGER.debug("Expected Key Schema for transformation, passing it unchanged. Message key: \"{}\"", ((ConnectRecord)record).key());
            return false;
        }
        return true;
    }

    public void validate(Configuration configuration, Field.Set fields) {
        Map<String, ConfigValue> validations = configuration.validate(fields);
        for (Map.Entry<String, ConfigValue> entry : validations.entrySet()) {
            if (entry.getValue().errorMessages().isEmpty()) continue;
            ConfigValue value = entry.getValue();
            throw new ConfigException(value.name(), value.value(), value.errorMessages().get(0));
        }
    }
}

