/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.text;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.cdc.common.text.ParsingException;
import org.apache.flink.cdc.common.text.Position;

@NotThreadSafe
public class TokenStream {
    public static final String ANY_VALUE = "any value";
    public static final int ANY_TYPE = Integer.MIN_VALUE;
    protected final String inputString;
    private final char[] inputContent;
    private final boolean caseSensitive;
    private final Tokenizer tokenizer;
    private List<Token> tokens;
    private ListIterator<Token> tokenIterator;
    private Token currentToken;
    private boolean completed;

    public TokenStream(String content, Tokenizer tokenizer, boolean caseSensitive) {
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(tokenizer, "tokenizer");
        this.inputString = content;
        this.inputContent = content.toCharArray();
        this.caseSensitive = caseSensitive;
        this.tokenizer = tokenizer;
    }

    public TokenStream start() throws ParsingException {
        if (this.tokens == null) {
            TokenFactory tokenFactory = this.caseSensitive ? new CaseSensitiveTokenFactory() : new CaseInsensitiveTokenFactory();
            CharacterArrayStream characterStream = new CharacterArrayStream(this.inputContent);
            this.tokenizer.tokenize(characterStream, tokenFactory);
            this.tokens = this.initializeTokens(tokenFactory.getTokens());
        }
        this.tokenIterator = this.tokens.listIterator();
        this.moveToNextToken();
        return this;
    }

    protected List<Token> initializeTokens(List<Token> tokens) {
        return tokens;
    }

    public Marker mark() {
        if (this.completed) {
            return new Marker(null, this.tokenIterator.previousIndex());
        }
        Token currentToken = this.currentToken();
        Position currentPosition = currentToken != null ? currentToken.position() : null;
        return new Marker(currentPosition, this.tokenIterator.previousIndex());
    }

    public boolean rewind(Marker marker) {
        if (marker.tokenIndex >= 0 && marker.tokenIndex <= this.tokenIterator.nextIndex()) {
            this.completed = false;
            this.currentToken = null;
            this.tokenIterator = this.tokens.listIterator(marker.tokenIndex);
            this.moveToNextToken();
            return true;
        }
        return false;
    }

    public String consume() throws ParsingException, IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        String result = this.currentToken().value();
        this.moveToNextToken();
        return result;
    }

    protected void throwNoMoreContent() throws ParsingException {
        Position pos = this.tokens.isEmpty() ? new Position(-1, 1, 0) : this.tokens.get(this.tokens.size() - 1).position();
        throw new ParsingException(pos, "No more content");
    }

    public String peek() throws IllegalStateException {
        if (this.completed) {
            this.throwNoMoreContent();
        }
        return this.currentToken().value();
    }

    public boolean matches(String expected) throws IllegalStateException {
        return this.matches(Integer.MIN_VALUE, expected);
    }

    public boolean matches(int type, String expected) throws IllegalStateException {
        return !this.completed && (Objects.equals(expected, ANY_VALUE) || this.currentToken().matches(expected)) && this.currentToken().matches(type);
    }

    public boolean matchesAnyOf(String[] options) throws IllegalStateException {
        if (this.completed) {
            return false;
        }
        Token current = this.currentToken();
        for (String option : options) {
            if (!current.matches(option)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNext() {
        if (this.tokenIterator == null) {
            throw new IllegalStateException("start() method must be called before hasNext()");
        }
        return !this.completed;
    }

    public String toString() {
        ListIterator<Token> iter = this.tokens.listIterator(this.tokenIterator.previousIndex());
        StringBuilder sb = new StringBuilder();
        if (iter.hasNext()) {
            sb.append(iter.next());
            int count = 1;
            while (iter.hasNext()) {
                if (count > 20) {
                    sb.append(" ...");
                    break;
                }
                sb.append("  ");
                ++count;
                sb.append(iter.next());
            }
        }
        return sb.toString();
    }

    private void moveToNextToken(List<Token> newTokens) {
        if (newTokens != null && !newTokens.isEmpty()) {
            for (Token t : newTokens) {
                this.tokenIterator.add(t);
            }
            for (int i = 0; i < newTokens.size() - 1; ++i) {
                this.tokenIterator.previous();
            }
            this.currentToken = newTokens.get(0);
            return;
        }
        if (!this.tokenIterator.hasNext()) {
            this.completed = true;
            this.currentToken = null;
        } else {
            this.currentToken = this.tokenIterator.next();
        }
    }

    private void moveToNextToken() {
        this.moveToNextToken(null);
    }

    final Token currentToken() throws IllegalStateException, NoSuchElementException {
        if (this.currentToken == null) {
            if (this.completed) {
                throw new NoSuchElementException("No more content");
            }
            throw new IllegalStateException("start() method must be called before consuming or matching");
        }
        return this.currentToken;
    }

    public static final class CharacterArrayStream
    implements CharacterStream {
        private final char[] content;
        private int lastIndex = -1;
        private final int maxIndex;
        private int lineNumber = 1;
        private int columnNumber = 0;
        private boolean nextCharMayBeLineFeed;

        public CharacterArrayStream(char[] content) {
            this.content = content;
            this.maxIndex = content.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.lastIndex < this.maxIndex;
        }

        @Override
        public int index() {
            return this.lastIndex;
        }

        @Override
        public Position position(int startIndex) {
            return new Position(startIndex, this.lineNumber, this.columnNumber);
        }

        @Override
        public char next() {
            if (this.lastIndex >= this.maxIndex) {
                throw new NoSuchElementException();
            }
            char result = this.content[++this.lastIndex];
            ++this.columnNumber;
            if (result == '\r') {
                this.nextCharMayBeLineFeed = true;
                ++this.lineNumber;
                this.columnNumber = 0;
            } else if (result == '\n') {
                if (!this.nextCharMayBeLineFeed) {
                    ++this.lineNumber;
                }
                this.columnNumber = 0;
            } else if (this.nextCharMayBeLineFeed) {
                this.nextCharMayBeLineFeed = false;
            }
            return result;
        }
    }

    public class CaseInsensitiveTokenFactory
    extends TokenFactory {
        @Override
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseInsensitiveToken(startIndex, endIndex, type, position));
        }
    }

    public class CaseSensitiveTokenFactory
    extends TokenFactory {
        @Override
        public void addToken(Position position, int startIndex, int endIndex, int type) {
            this.tokens.add(new CaseSensitiveToken(startIndex, endIndex, type, position));
        }
    }

    protected abstract class TokenFactory
    implements Tokens {
        protected final List<Token> tokens = new ArrayList<Token>();

        protected TokenFactory() {
        }

        public List<Token> getTokens() {
            return this.tokens;
        }
    }

    @Immutable
    protected class CaseInsensitiveToken
    extends CaseSensitiveToken {
        public CaseInsensitiveToken(int startIndex, int endIndex, int type, Position position) {
            super(startIndex, endIndex, type, position);
        }

        @Override
        public boolean matches(String expected) {
            return this.matchString().substring(this.startIndex(), this.endIndex()).toUpperCase().equals(expected);
        }

        @Override
        public Token withType(int typeMask) {
            int type = this.type() | typeMask;
            return new CaseInsensitiveToken(this.startIndex(), this.endIndex(), type, this.position());
        }
    }

    @Immutable
    protected class CaseSensitiveToken
    implements Token {
        private final int startIndex;
        private final int endIndex;
        private final int type;
        private final Position position;

        public CaseSensitiveToken(int startIndex, int endIndex, int type, Position position) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.type = type;
            this.position = position;
        }

        @Override
        public Token withType(int typeMask) {
            int type = this.type | typeMask;
            return new CaseSensitiveToken(this.startIndex, this.endIndex, type, this.position);
        }

        @Override
        public final int type() {
            return this.type;
        }

        @Override
        public final int startIndex() {
            return this.startIndex;
        }

        @Override
        public final int endIndex() {
            return this.endIndex;
        }

        @Override
        public final int length() {
            return this.endIndex - this.startIndex;
        }

        @Override
        public final boolean matches(char expected) {
            return this.length() == 1 && this.matchString().charAt(this.startIndex) == expected;
        }

        @Override
        public boolean matches(String expected) {
            return this.matchString().substring(this.startIndex, this.endIndex).equals(expected);
        }

        @Override
        public final boolean matches(int expectedType) {
            return expectedType == Integer.MIN_VALUE || (TokenStream.this.currentToken().type() & expectedType) == expectedType;
        }

        @Override
        public final String value() {
            return TokenStream.this.inputString.substring(this.startIndex, this.endIndex);
        }

        @Override
        public Position position() {
            return this.position;
        }

        protected String matchString() {
            return TokenStream.this.inputString;
        }

        public String toString() {
            return this.value();
        }
    }

    @Immutable
    public static interface Token {
        public String value();

        public boolean matches(String var1);

        default public boolean matches(int expectedType, String expected) {
            return this.matches(expectedType) && this.matches(expected);
        }

        public boolean matches(char var1);

        public boolean matches(int var1);

        public int type();

        public int startIndex();

        public int endIndex();

        public int length();

        public Position position();

        public Token withType(int var1);
    }

    public static interface Tokens {
        default public void addToken(Position position, int index) {
            this.addToken(position, index, index + 1, 0);
        }

        default public void addToken(Position position, int startIndex, int endIndex) {
            this.addToken(position, startIndex, endIndex, 0);
        }

        public void addToken(Position var1, int var2, int var3, int var4);
    }

    public static interface CharacterStream {
        public boolean hasNext();

        public char next();

        public int index();

        public Position position(int var1);
    }

    public static interface Tokenizer {
        public void tokenize(CharacterStream var1, Tokens var2) throws ParsingException;
    }

    public static final class Marker
    implements Comparable<Marker> {
        private final int tokenIndex;
        private final Position position;

        private Marker(Position position, int index) {
            this.position = position;
            this.tokenIndex = index;
        }

        public Position position() {
            return this.position;
        }

        @Override
        public int compareTo(Marker that) {
            if (this == that) {
                return 0;
            }
            return this.tokenIndex - that.tokenIndex;
        }

        public String toString() {
            return Integer.toString(this.tokenIndex);
        }
    }
}

