/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.health;

import java.util.Objects;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;

public abstract class AbstractState {
    private final String state;
    private final String traceMessage;
    private final String workerId;

    public AbstractState(String state, String workerId, String traceMessage) {
        if (Utils.isBlank(state)) {
            throw new IllegalArgumentException("State must not be null or empty");
        }
        if (Utils.isBlank(workerId)) {
            throw new IllegalArgumentException("Worker ID must not be null or empty");
        }
        this.state = state;
        this.workerId = workerId;
        this.traceMessage = traceMessage;
    }

    public String state() {
        return this.state;
    }

    public String workerId() {
        return this.workerId;
    }

    public String traceMessage() {
        return this.traceMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractState that = (AbstractState)o;
        return this.state.equals(that.state) && Objects.equals(this.traceMessage, that.traceMessage) && this.workerId.equals(that.workerId);
    }

    public int hashCode() {
        return Objects.hash(this.state, this.traceMessage, this.workerId);
    }
}

