/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.config;

import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import java.time.Duration;
import java.util.List;
import java.util.Properties;
import org.apache.flink.cdc.connectors.base.config.BaseSourceConfig;
import org.apache.flink.cdc.connectors.base.options.StartupOptions;

public abstract class JdbcSourceConfig
extends BaseSourceConfig {
    protected final String driverClassName;
    protected final String hostname;
    protected final int port;
    protected final String username;
    protected final String password;
    protected final List<String> databaseList;
    protected final List<String> schemaList;
    protected final List<String> tableList;
    protected final int fetchSize;
    protected final String serverTimeZone;
    protected final Duration connectTimeout;
    protected final int connectMaxRetries;
    protected final int connectionPoolSize;
    protected final String chunkKeyColumn;

    public JdbcSourceConfig(StartupOptions startupOptions, List<String> databaseList, List<String> schemaList, List<String> tableList, int splitSize, int splitMetaGroupSize, double distributionFactorUpper, double distributionFactorLower, boolean includeSchemaChanges, boolean closeIdleReaders, Properties dbzProperties, Configuration dbzConfiguration, String driverClassName, String hostname, int port, String username, String password, int fetchSize, String serverTimeZone, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, String chunkKeyColumn, boolean skipSnapshotBackfill, boolean isScanNewlyAddedTableEnabled, boolean assignUnboundedChunkFirst) {
        super(startupOptions, splitSize, splitMetaGroupSize, distributionFactorUpper, distributionFactorLower, includeSchemaChanges, closeIdleReaders, skipSnapshotBackfill, isScanNewlyAddedTableEnabled, dbzProperties, dbzConfiguration, assignUnboundedChunkFirst);
        this.driverClassName = driverClassName;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
        this.databaseList = databaseList;
        this.schemaList = schemaList;
        this.tableList = tableList;
        this.fetchSize = fetchSize;
        this.serverTimeZone = serverTimeZone;
        this.connectTimeout = connectTimeout;
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.chunkKeyColumn = chunkKeyColumn;
    }

    public abstract RelationalDatabaseConnectorConfig getDbzConnectorConfig();

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    public List<String> getTableList() {
        return this.tableList;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectMaxRetries() {
        return this.connectMaxRetries;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public String getChunkKeyColumn() {
        return this.chunkKeyColumn;
    }

    @Override
    public boolean isScanNewlyAddedTableEnabled() {
        return this.isScanNewlyAddedTableEnabled;
    }

    public RelationalTableFilters getTableFilters() {
        return this.getDbzConnectorConfig().getTableFilters();
    }
}

