/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.utils;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.flink.util.function.SupplierWithException;

public class TestCaseUtils {
    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    public static final Duration DEFAULT_INTERVAL = Duration.ofSeconds(1L);

    public static void repeatedCheck(Supplier<Boolean> fetcher) {
        TestCaseUtils.repeatedCheck(fetcher, DEFAULT_TIMEOUT);
    }

    public static void repeatedCheck(Supplier<Boolean> fetcher, Duration timeout) {
        TestCaseUtils.repeatedCheck(fetcher, timeout, DEFAULT_INTERVAL);
    }

    public static void repeatedCheck(Supplier<Boolean> fetcher, Duration timeout, Duration interval) {
        TestCaseUtils.repeatedCheck((SupplierWithException<Boolean, Throwable>)((SupplierWithException)fetcher::get), timeout, interval, Collections.emptyList());
    }

    public static <T> void repeatedCheck(Supplier<T> fetcher, Predicate<T> validator, Duration timeout, Duration interval) {
        TestCaseUtils.repeatedCheckAndValidate(fetcher::get, validator, timeout, interval, Collections.emptyList());
    }

    public static void repeatedCheck(SupplierWithException<Boolean, Throwable> fetcher, Duration timeout, Duration interval, List<Class<? extends Throwable>> allowedThrowsList) {
        TestCaseUtils.repeatedCheckAndValidate(fetcher, b -> b, timeout, interval, allowedThrowsList);
    }

    public static <T> void repeatedCheckAndValidate(SupplierWithException<T, Throwable> fetcher, Predicate<T> validator, Duration timeout, Duration interval, List<Class<? extends Throwable>> allowedThrowsList) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout.toMillis()) {
            block6: {
                try {
                    if (validator.test(fetcher.get())) {
                        return;
                    }
                }
                catch (Throwable t) {
                    if (!allowedThrowsList.stream().noneMatch(clazz -> clazz.isAssignableFrom(t.getClass()))) break block6;
                    throw new RuntimeException("Fetcher has thrown an unexpected exception: ", t);
                }
            }
            try {
                Thread.sleep(interval.toMillis());
            }
            catch (InterruptedException interruptedException) {}
        }
        throw new RuntimeException("Timeout when waiting for state to be ready.");
    }
}

