/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.Objects;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.TableId;

@PublicEvolving
public class DropTableEvent
implements SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;

    public DropTableEvent(TableId tableId) {
        this.tableId = tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DropTableEvent)) {
            return false;
        }
        DropTableEvent that = (DropTableEvent)o;
        return Objects.equals(this.tableId, that.tableId);
    }

    public int hashCode() {
        return Objects.hash(this.tableId);
    }

    public String toString() {
        return "DropTableEvent{tableId=" + this.tableId + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.DROP_TABLE;
    }

    @Override
    public SchemaChangeEvent copy(TableId newTableId) {
        return new DropTableEvent(newTableId);
    }
}

