/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.event;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.SchemaChangeEventType;
import org.apache.flink.cdc.common.event.SchemaChangeEventWithPreSchema;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;

@PublicEvolving
public class AlterColumnTypeEvent
implements SchemaChangeEventWithPreSchema,
SchemaChangeEvent {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final Map<String, DataType> typeMapping;
    private final Map<String, DataType> oldTypeMapping;

    public AlterColumnTypeEvent(TableId tableId, Map<String, DataType> typeMapping) {
        this.tableId = tableId;
        this.typeMapping = typeMapping;
        this.oldTypeMapping = new HashMap<String, DataType>();
    }

    public AlterColumnTypeEvent(TableId tableId, Map<String, DataType> typeMapping, Map<String, DataType> oldTypeMapping) {
        this.tableId = tableId;
        this.typeMapping = typeMapping;
        this.oldTypeMapping = oldTypeMapping;
    }

    public Map<String, DataType> getTypeMapping() {
        return this.typeMapping;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterColumnTypeEvent)) {
            return false;
        }
        AlterColumnTypeEvent that = (AlterColumnTypeEvent)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.typeMapping, that.typeMapping) && Objects.equals(this.oldTypeMapping, that.oldTypeMapping);
    }

    public int hashCode() {
        return Objects.hash(this.tableId, this.typeMapping, this.oldTypeMapping);
    }

    public String toString() {
        if (this.hasPreSchema()) {
            return "AlterColumnTypeEvent{tableId=" + this.tableId + ", typeMapping=" + this.typeMapping + ", oldTypeMapping=" + this.oldTypeMapping + '}';
        }
        return "AlterColumnTypeEvent{tableId=" + this.tableId + ", typeMapping=" + this.typeMapping + '}';
    }

    @Override
    public TableId tableId() {
        return this.tableId;
    }

    public Map<String, DataType> getOldTypeMapping() {
        return this.oldTypeMapping;
    }

    @Override
    public boolean hasPreSchema() {
        return !this.oldTypeMapping.isEmpty();
    }

    @Override
    public void fillPreSchema(Schema oldTypeSchema) {
        this.oldTypeMapping.clear();
        this.oldTypeMapping.putAll(oldTypeSchema.getColumns().stream().filter(e -> this.typeMapping.containsKey(e.getName()) && e.getType() != null).collect(Collectors.toMap(Column::getName, Column::getType)));
    }

    @Override
    public boolean trimRedundantChanges() {
        if (this.hasPreSchema()) {
            Set redundantlyChangedColumns = this.typeMapping.keySet().stream().filter(e -> Objects.equals(this.typeMapping.get(e), this.oldTypeMapping.get(e))).collect(Collectors.toSet());
            this.typeMapping.keySet().removeAll(redundantlyChangedColumns);
            this.oldTypeMapping.keySet().removeAll(redundantlyChangedColumns);
        }
        return !this.typeMapping.isEmpty();
    }

    @Override
    public SchemaChangeEventType getType() {
        return SchemaChangeEventType.ALTER_COLUMN_TYPE;
    }

    @Override
    public SchemaChangeEvent copy(TableId newTableId) {
        return new AlterColumnTypeEvent(newTableId, this.typeMapping, this.oldTypeMapping);
    }
}

