/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.common.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.data.ArrayData;
import org.apache.flink.cdc.common.data.DecimalData;
import org.apache.flink.cdc.common.data.LocalZonedTimestampData;
import org.apache.flink.cdc.common.data.MapData;
import org.apache.flink.cdc.common.data.StringData;
import org.apache.flink.cdc.common.data.TimestampData;
import org.apache.flink.cdc.common.data.ZonedTimestampData;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.common.types.DataTypeChecks;

@PublicEvolving
public interface RecordData {
    public int getArity();

    public boolean isNullAt(int var1);

    public boolean getBoolean(int var1);

    public byte getByte(int var1);

    public short getShort(int var1);

    public int getInt(int var1);

    public long getLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public byte[] getBinary(int var1);

    public StringData getString(int var1);

    public DecimalData getDecimal(int var1, int var2, int var3);

    public TimestampData getTimestamp(int var1, int var2);

    public ZonedTimestampData getZonedTimestamp(int var1, int var2);

    public LocalZonedTimestampData getLocalZonedTimestampData(int var1, int var2);

    public ArrayData getArray(int var1);

    public MapData getMap(int var1);

    public RecordData getRow(int var1, int var2);

    public static FieldGetter createFieldGetter(DataType fieldType, int fieldPos) {
        FieldGetter fieldGetter;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldGetter = record -> record.getString(fieldPos);
                break;
            }
            case BOOLEAN: {
                fieldGetter = record -> record.getBoolean(fieldPos);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldGetter = record -> record.getBinary(fieldPos);
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(fieldType);
                int decimalScale = DataTypeChecks.getScale(fieldType);
                fieldGetter = record -> record.getDecimal(fieldPos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                fieldGetter = record -> record.getByte(fieldPos);
                break;
            }
            case SMALLINT: {
                fieldGetter = record -> record.getShort(fieldPos);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldGetter = record -> record.getInt(fieldPos);
                break;
            }
            case BIGINT: {
                fieldGetter = record -> record.getLong(fieldPos);
                break;
            }
            case FLOAT: {
                fieldGetter = record -> Float.valueOf(record.getFloat(fieldPos));
                break;
            }
            case DOUBLE: {
                fieldGetter = record -> record.getDouble(fieldPos);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                fieldGetter = record -> record.getTimestamp(fieldPos, DataTypeChecks.getPrecision(fieldType));
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                fieldGetter = record -> record.getLocalZonedTimestampData(fieldPos, DataTypeChecks.getPrecision(fieldType));
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                fieldGetter = record -> record.getZonedTimestamp(fieldPos, DataTypeChecks.getPrecision(fieldType));
                break;
            }
            case ARRAY: {
                fieldGetter = record -> record.getArray(fieldPos);
                break;
            }
            case MAP: {
                fieldGetter = record -> record.getMap(fieldPos);
                break;
            }
            case ROW: {
                int rowFieldCount = DataTypeChecks.getFieldCount(fieldType);
                fieldGetter = row -> row.getRow(fieldPos, rowFieldCount);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (!fieldType.isNullable()) {
            return fieldGetter;
        }
        return row -> {
            if (row.isNullAt(fieldPos)) {
                return null;
            }
            return fieldGetter.getFieldOrNull(row);
        };
    }

    @PublicEvolving
    public static interface FieldGetter
    extends Serializable {
        @Nullable
        public Object getFieldOrNull(RecordData var1);
    }
}

