/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.Duration;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresObjectUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresObjectUtils.class);

    public static PostgresSchema newSchema(PostgresConnection connection, PostgresConnectorConfig config, TypeRegistry typeRegistry, TopicSelector<TableId> topicSelector, PostgresValueConverter valueConverter) throws SQLException {
        PostgresSchema schema = new PostgresSchema(config, typeRegistry, connection.getDefaultValueConverter(), topicSelector, valueConverter);
        schema.refresh(connection, false);
        return schema;
    }

    public static PostgresTaskContext newTaskContext(PostgresConnectorConfig connectorConfig, PostgresSchema schema, TopicSelector<TableId> topicSelector) {
        return new PostgresTaskContext(connectorConfig, schema, topicSelector);
    }

    public static PostgresEventMetadataProvider newEventMetadataProvider() {
        return new PostgresEventMetadataProvider();
    }

    public static PostgresConnection.PostgresValueConverterBuilder newPostgresValueConverterBuilder(PostgresConnectorConfig config) {
        return typeRegistry -> PostgresValueConverter.of(config, StandardCharsets.UTF_8, typeRegistry);
    }

    public static ReplicationConnection createReplicationConnection(PostgresTaskContext taskContext, PostgresConnection postgresConnection, boolean doSnapshot, PostgresConnectorConfig connectorConfig) {
        short s = connectorConfig.maxRetries();
        Duration retryDelay = connectorConfig.retryDelay();
        Metronome metronome = Metronome.parker(retryDelay, Clock.SYSTEM);
        short retryCount = 0;
        while (retryCount <= s) {
            try {
                LOGGER.info("Creating a new replication connection for {}", (Object)taskContext);
                return taskContext.createReplicationConnection(doSnapshot, postgresConnection);
            }
            catch (SQLException ex) {
                retryCount = (short)(retryCount + 1);
                if (retryCount > s) {
                    LOGGER.error("Too many errors connecting to server. All {} retries failed.", (Object)s);
                    throw new FlinkRuntimeException((Throwable)ex);
                }
                LOGGER.warn("Error connecting to server; will attempt retry {} of {} after {} seconds. Exception message: {}", new Object[]{retryCount, (int)s, retryDelay.getSeconds(), ex.getMessage()});
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Connection retry sleep interrupted by exception: " + e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        LOGGER.error("Failed to create replication connection after {} retries", (Object)s);
        throw new FlinkRuntimeException("Failed to create replication connection for " + taskContext);
    }

    public static void waitForReplicationSlotReady(int retryTimes, PostgresConnection jdbcConnection, String slotName, String pluginName) throws SQLException {
        SlotState slotState = jdbcConnection.getReplicationSlotState(slotName, pluginName);
        for (int count = 0; slotState == null && count < retryTimes; ++count) {
            LOGGER.info("Waiting until the replication slot is ready ...");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            slotState = jdbcConnection.getReplicationSlotState(slotName, pluginName);
        }
        if (slotState == null) {
            throw new IllegalStateException(String.format("The replication slot is not ready after %d seconds.", 2 * retryTimes));
        }
    }
}

