/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.oms.logmessage;

public class Checkpoint {
    private String recordId;
    private String position;
    private String timestamp;
    private String serverId;
    private static final String DELIMITER = ":";

    public Checkpoint() {
        this.timestamp = null;
        this.serverId = null;
        this.position = null;
        this.recordId = null;
    }

    public Checkpoint(String recordId, String position, String serverId, String timestamp) {
        this.recordId = recordId;
        this.position = position;
        this.serverId = serverId;
        this.timestamp = timestamp;
    }

    public Checkpoint(Checkpoint cp) {
        this(cp.recordId, cp.position, cp.serverId, cp.timestamp);
    }

    public boolean equals(String cp) {
        if (this.position != null && cp != null) {
            return this.position.equals(cp);
        }
        if (this.timestamp != null && cp != null) {
            return this.timestamp.equals(cp);
        }
        return false;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        String cp = position;
        if (cp.contains("@mysql-bin.")) {
            int m = cp.indexOf(64);
            int p = cp.indexOf(46);
            String cp1 = cp.substring(0, m);
            String cp2 = cp.substring(p + 1);
            long lcp2 = Long.parseLong(cp2);
            cp = cp1 + "@" + lcp2;
        }
        this.position = cp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String toString() {
        String cp1 = null;
        String cp2 = null;
        if (this.position != null && !this.position.isEmpty()) {
            int in = this.position.indexOf(64);
            cp1 = this.position.substring(in + 1);
            cp2 = this.position.substring(0, in);
        }
        StringBuilder builder = new StringBuilder();
        if (this.serverId == null || this.serverId.isEmpty()) {
            builder.append(DELIMITER).append(DELIMITER);
        } else {
            int in = this.serverId.indexOf(45);
            String db = this.serverId.substring(0, in);
            String dbport = this.serverId.substring(in + 1);
            builder.append(db).append(DELIMITER).append(dbport).append(DELIMITER);
        }
        if (cp1 != null && cp2 != null) {
            builder.append(cp1).append(DELIMITER).append(cp2).append(DELIMITER);
        } else {
            builder.append(DELIMITER).append(DELIMITER);
        }
        if (this.timestamp != null) {
            builder.append(this.timestamp).append(DELIMITER);
        } else {
            builder.append(DELIMITER);
        }
        if (this.recordId != null) {
            builder.append(this.recordId);
        }
        return builder.toString();
    }
}

