/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.oceanbase.source.converter;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.data.Bits;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Year;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Locale;
import org.apache.flink.cdc.connectors.oceanbase.source.config.OceanBaseConnectorConfig;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Decimal;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Time;

public class OceanBaseValueConverters
extends JdbcValueConverters {
    public static final String EMPTY_BLOB_FUNCTION = "EMPTY_BLOB()";
    public static final String EMPTY_CLOB_FUNCTION = "EMPTY_CLOB()";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd HH:mm:ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().toFormatter();
    private static final DateTimeFormatter TIMESTAMP_AM_PM_SHORT_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("dd-MMM-yy hh.mm.ss").optionalStart().appendPattern(".").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, false).optionalEnd().appendPattern(" a").toFormatter(Locale.ENGLISH);
    private final String compatibleMode;
    private final String serverTimezone;

    public OceanBaseValueConverters(OceanBaseConnectorConfig connectorConfig) {
        super(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode(), ZoneOffset.UTC, x -> x, JdbcValueConverters.BigIntUnsignedMode.PRECISE, connectorConfig.binaryHandlingMode());
        this.compatibleMode = connectorConfig.getCompatibleMode();
        this.serverTimezone = connectorConfig.getServerTimeZone();
    }

    @Override
    protected int getTimePrecision(Column column) {
        if ("mysql".equalsIgnoreCase(this.compatibleMode)) {
            return super.getTimePrecision(column);
        }
        return column.scale().orElse(0);
    }

    protected boolean isUnsignedColumn(Column column) {
        return column.typeName().toUpperCase().contains("UNSIGNED");
    }

    @Override
    public SchemaBuilder schemaBuilder(Column column) {
        this.logger.debug("Building schema for column {} of type {} named {} with constraints ({},{})", new Object[]{column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale()});
        switch (column.jdbcType()) {
            case -7: {
                if (column.length() > 1) {
                    return Bits.builder(column.length());
                }
                return SchemaBuilder.bool();
            }
            case -6: {
                if (column.length() == 1) {
                    return SchemaBuilder.bool();
                }
                if (this.isUnsignedColumn(column)) {
                    return SchemaBuilder.int16();
                }
                return SchemaBuilder.int8();
            }
            case 5: {
                if (this.isUnsignedColumn(column)) {
                    return SchemaBuilder.int32();
                }
                return SchemaBuilder.int16();
            }
            case 4: {
                if (!column.typeName().toUpperCase().startsWith("MEDIUMINT") && this.isUnsignedColumn(column)) {
                    return SchemaBuilder.int64();
                }
                return SchemaBuilder.int32();
            }
            case -5: {
                if (this.isUnsignedColumn(column)) {
                    return Decimal.builder(0);
                }
                return SchemaBuilder.int64();
            }
            case 6: {
                return this.getDecimalSchema(column);
            }
            case 2: 
            case 3: {
                if ("mysql".equalsIgnoreCase(this.compatibleMode)) {
                    return this.getDecimalSchema(column);
                }
                return this.getNumericSchema(column);
            }
            case 7: {
                return SchemaBuilder.float32();
            }
            case 8: {
                return SchemaBuilder.float64();
            }
            case 91: {
                if ("mysql".equalsIgnoreCase(this.compatibleMode)) {
                    if (column.typeName().equalsIgnoreCase("YEAR")) {
                        return Year.builder();
                    }
                    if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
                        return io.debezium.time.Date.builder();
                    }
                    return org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Date.builder();
                }
                return this.getTimestampSchema(column);
            }
            case 92: {
                if (this.adaptiveTimeMicrosecondsPrecisionMode) {
                    return MicroTime.builder();
                }
                if (this.adaptiveTimePrecisionMode) {
                    if (this.getTimePrecision(column) <= 3) {
                        return io.debezium.time.Time.builder();
                    }
                    if (this.getTimePrecision(column) <= 6) {
                        return MicroTime.builder();
                    }
                    return NanoTime.builder();
                }
                return Time.builder();
            }
            case 93: {
                return this.getTimestampSchema(column);
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return SchemaBuilder.string();
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.binaryMode.getSchema();
            }
        }
        return super.schemaBuilder(column);
    }

    protected SchemaBuilder getNumericSchema(Column column) {
        int scale;
        if (column.scale().isPresent() && (scale = column.scale().get().intValue()) <= 0) {
            int width = column.length() - scale;
            if (width < 3) {
                return SchemaBuilder.int8();
            }
            if (width < 5) {
                return SchemaBuilder.int16();
            }
            if (width < 10) {
                return SchemaBuilder.int32();
            }
            if (width < 19) {
                return SchemaBuilder.int64();
            }
        }
        return this.getDecimalSchema(column);
    }

    protected SchemaBuilder getDecimalSchema(Column column) {
        return SpecialValueDecimal.builder(this.decimalMode, column.length(), column.scale().orElse(0));
    }

    protected SchemaBuilder getTimestampSchema(Column column) {
        if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
            if (this.getTimePrecision(column) <= 3) {
                return io.debezium.time.Timestamp.builder();
            }
            if (this.getTimePrecision(column) <= 6) {
                return MicroTimestamp.builder();
            }
            return NanoTimestamp.builder();
        }
        return org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp.builder();
    }

    @Override
    public ValueConverter converter(Column column, Field fieldDefn) {
        switch (column.jdbcType()) {
            case -7: {
                return this.convertBits(column, fieldDefn);
            }
            case -6: {
                if (column.length() == 1) {
                    return data -> this.convertBit(column, fieldDefn, data);
                }
                if (this.isUnsignedColumn(column)) {
                    return data -> this.convertSmallInt(column, fieldDefn, data);
                }
                return data -> this.convertTinyInt(column, fieldDefn, data);
            }
            case 5: {
                if (this.isUnsignedColumn(column)) {
                    return data -> this.convertInteger(column, fieldDefn, data);
                }
                return data -> this.convertSmallInt(column, fieldDefn, data);
            }
            case 4: {
                if (column.typeName().toUpperCase().startsWith("MEDIUMINT")) {
                    return data -> this.convertInteger(column, fieldDefn, data);
                }
                if (this.isUnsignedColumn(column)) {
                    return data -> this.convertBigInt(column, fieldDefn, data);
                }
                return data -> this.convertInteger(column, fieldDefn, data);
            }
            case -5: {
                if (this.isUnsignedColumn(column)) {
                    switch (this.bigIntUnsignedMode) {
                        case LONG: {
                            return data -> this.convertBigInt(column, fieldDefn, data);
                        }
                        case PRECISE: {
                            return data -> this.convertUnsignedBigint(column, fieldDefn, data);
                        }
                    }
                }
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 6: {
                return data -> this.convertDecimal(column, fieldDefn, data);
            }
            case 2: 
            case 3: {
                if ("mysql".equalsIgnoreCase(this.compatibleMode)) {
                    return data -> this.convertDecimal(column, fieldDefn, data);
                }
                return data -> this.convertNumeric(column, fieldDefn, data);
            }
            case 7: {
                return data -> this.convertReal(column, fieldDefn, data);
            }
            case 8: {
                return data -> this.convertDouble(column, fieldDefn, data);
            }
            case 91: {
                if ("mysql".equalsIgnoreCase(this.compatibleMode)) {
                    if (column.typeName().equalsIgnoreCase("YEAR")) {
                        return data -> this.convertYearToInt(column, fieldDefn, data);
                    }
                    if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
                        return data -> this.convertDateToEpochDays(column, fieldDefn, data);
                    }
                    return data -> this.convertDateToEpochDaysAsDate(column, fieldDefn, data);
                }
                return data -> this.convertTimestamp(column, fieldDefn, data);
            }
            case 92: {
                return data -> this.convertTime(column, fieldDefn, data);
            }
            case 93: {
                return data -> this.convertTimestamp(column, fieldDefn, data);
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
        }
        return super.converter(column, fieldDefn);
    }

    @Override
    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        if (data instanceof String) {
            return ByteBuffer.allocate(numBytes).putLong(Long.parseLong((String)data)).array();
        }
        return super.convertBits(column, fieldDefn, data, numBytes);
    }

    @Override
    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Boolean.parseBoolean((String)data) || "1".equals(data);
        }
        return super.convertBit(column, fieldDefn, data);
    }

    @Override
    protected Object convertTinyInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Byte.parseByte((String)data);
        }
        if (data instanceof Number) {
            return ((Number)data).byteValue();
        }
        throw new IllegalArgumentException("Unexpected value for JDBC type " + column.jdbcType() + " and column " + column + ": class=" + data.getClass());
    }

    @Override
    protected Object convertBigInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return new BigInteger((String)data).longValue();
        }
        return super.convertBigInt(column, fieldDefn, data);
    }

    protected Object convertUnsignedBigint(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return new BigDecimal((String)data);
        }
        if (data instanceof BigInteger) {
            return new BigDecimal((BigInteger)data);
        }
        return this.convertDecimal(column, fieldDefn, data);
    }

    @Override
    protected Object convertReal(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Float.valueOf(Float.parseFloat((String)data));
        }
        return super.convertReal(column, fieldDefn, data);
    }

    @Override
    protected Object convertDouble(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            return Double.parseDouble((String)data);
        }
        return super.convertDouble(column, fieldDefn, data);
    }

    @Override
    protected Object convertNumeric(Column column, Field fieldDefn, Object data) {
        int scale;
        if (column.scale().isPresent() && (scale = column.scale().get().intValue()) <= 0) {
            int width = column.length() - scale;
            if (width < 3) {
                return this.convertTinyInt(column, fieldDefn, data);
            }
            if (width < 5) {
                return this.convertSmallInt(column, fieldDefn, data);
            }
            if (width < 10) {
                return this.convertInteger(column, fieldDefn, data);
            }
            if (width < 19) {
                return this.convertBigInt(column, fieldDefn, data);
            }
        }
        return this.convertDecimal(column, fieldDefn, data);
    }

    protected Object convertYearToInt(Column column, Field fieldDefn, Object data) {
        if (data instanceof Date) {
            return ((Date)data).toLocalDate().getYear();
        }
        return this.convertInteger(column, fieldDefn, data);
    }

    @Override
    protected Object convertDateToEpochDays(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Date.valueOf((String)data);
        }
        return super.convertDateToEpochDays(column, fieldDefn, data);
    }

    @Override
    protected Object convertDateToEpochDaysAsDate(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Date.valueOf((String)data);
        }
        return super.convertDateToEpochDaysAsDate(column, fieldDefn, data);
    }

    @Override
    protected Object convertTime(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = java.sql.Time.valueOf((String)data);
        }
        return super.convertTime(column, fieldDefn, data);
    }

    protected Object convertTimestamp(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = "mysql".equalsIgnoreCase(this.compatibleMode) ? Timestamp.valueOf(((String)((Object)data)).trim()) : this.resolveTimestampStringAsInstant((String)((Object)data));
        }
        if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
            if (this.getTimePrecision(column) <= 3) {
                return this.convertTimestampToEpochMillis(column, fieldDefn, data);
            }
            if (this.getTimePrecision(column) <= 6) {
                return this.convertTimestampToEpochMicros(column, fieldDefn, data);
            }
            return this.convertTimestampToEpochNanos(column, fieldDefn, data);
        }
        return this.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
    }

    protected Instant resolveTimestampStringAsInstant(String dateText) {
        LocalDateTime dateTime = dateText.indexOf(" AM") > 0 || dateText.indexOf(" PM") > 0 ? LocalDateTime.from(TIMESTAMP_AM_PM_SHORT_FORMATTER.parse(dateText.trim())) : LocalDateTime.from(TIMESTAMP_FORMATTER.parse(dateText.trim()));
        return dateTime.atZone(ZoneId.of(this.serverTimezone)).toInstant();
    }

    @Override
    protected Object convertString(Column column, Field fieldDefn, Object data) {
        String s;
        if (data instanceof Clob) {
            try {
                Clob clob = (Clob)data;
                return clob.getSubString(1L, (int)clob.length());
            }
            catch (SQLException e) {
                throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
            }
        }
        if (data instanceof String && EMPTY_CLOB_FUNCTION.equals(s = (String)data)) {
            return column.isOptional() ? null : "";
        }
        return super.convertString(column, fieldDefn, data);
    }

    @Override
    protected Object convertBinary(Column column, Field fieldDefn, Object data, CommonConnectorConfig.BinaryHandlingMode mode) {
        try {
            String str;
            if (data instanceof Blob) {
                Blob blob = (Blob)data;
                data = blob.getBytes(1L, Long.valueOf(blob.length()).intValue());
            }
            if (data instanceof String && EMPTY_BLOB_FUNCTION.equals(str = (String)data)) {
                data = column.isOptional() ? null : "";
            }
            return super.convertBinary(column, fieldDefn, data, mode);
        }
        catch (SQLException e) {
            throw new RuntimeException("Couldn't convert value for column " + column.name(), e);
        }
    }
}

